/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class Database
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Dialect dialect;
    protected final Map<String, Table> tables;
    protected final Set<String> physicalTables;

    public Database(Dialect dialect) {
        this.dialect = dialect;
        this.tables = new LinkedHashMap<String, Table>();
        this.physicalTables = new HashSet<String>();
    }

    public Table addTable(String name) throws IllegalArgumentException {
        String physicalName = this.dialect.getTableName(name);
        if (!this.physicalTables.add(physicalName)) {
            throw new IllegalArgumentException("Duplicate table name: " + physicalName);
        }
        TableImpl table = new TableImpl(this.dialect, physicalName, name);
        this.tables.put(name, table);
        return table;
    }

    public Table getTable(String name) {
        return this.tables.get(name);
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('(');
        Iterator<Table> iter = this.tables.values().iterator();
        while (iter.hasNext()) {
            Table table = iter.next();
            buf.append(table.getPhysicalName());
            if (!iter.hasNext()) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }
}

