/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class ConstraintRelaxingPseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] bestModel;
    private boolean[] bestFullModel;
    private IConstr previousPBConstr;
    private IConstr addedConstr = null;
    private int maxValue = 0;
    private Number objectiveValue;
    private boolean optimumFound = false;

    public ConstraintRelaxingPseudoOptDecorator(IPBSolver solver) {
        super(solver);
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        boolean result = super.isSatisfiable(assumps, true);
        if (result) {
            this.bestModel = super.model();
            this.bestFullModel = new boolean[this.nVars()];
            int i = 0;
            while (i < this.nVars()) {
                this.bestFullModel[i] = ((IPBSolver)this.decorated()).model(i + 1);
                ++i;
            }
            this.calculateObjective();
        } else if (this.previousPBConstr != null) {
            ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
            this.previousPBConstr = null;
        }
        return result;
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, true);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        if (this.optimumFound) {
            return false;
        }
        this.maxValue = this.getObjectiveFunction().minValue().intValue();
        while (true) {
            if (this.addedConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
            }
            try {
                this.forceObjectiveValueTo(new Integer(this.maxValue++));
            }
            catch (ContradictionException contradictionException) {
                if (!this.isVerbose()) continue;
                System.out.println(String.valueOf(((IPBSolver)this.decorated()).getLogPrefix()) + "no solution for objective value " + (this.maxValue - 1));
                continue;
            }
            boolean isSatisfiable = super.isSatisfiable(assumps, true);
            if (isSatisfiable) {
                this.optimumFound = true;
                this.bestModel = super.model();
                this.bestFullModel = new boolean[this.nVars()];
                int i = 0;
                while (i < this.nVars()) {
                    this.bestFullModel[i] = ((IPBSolver)this.decorated()).model(i + 1);
                    ++i;
                }
                if (this.getObjectiveFunction() != null) {
                    this.calculateObjective();
                }
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
                return true;
            }
            if (!this.isVerbose()) continue;
            System.out.println(String.valueOf(((IPBSolver)this.decorated()).getLogPrefix()) + "no solution for objective value " + (this.maxValue - 1));
        }
    }

    public boolean hasNoObjectiveFunction() {
        return this.getObjectiveFunction() == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        if (this.getObjectiveFunction() == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = this.getObjectiveFunction().calculateDegree(this);
        return this.objectiveValue;
    }

    public Number getObjectiveValue() {
        return this.objectiveValue;
    }

    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        this.addedConstr = super.addPseudoBoolean(this.getObjectiveFunction().getVars(), this.getObjectiveFunction().getCoeffs(), false, BigInteger.valueOf(forcedValue.longValue()));
    }

    public void discard() {
        this.discardCurrentSolution();
    }

    public void discardCurrentSolution() {
    }

    public boolean isOptimal() {
        return this.optimumFound;
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + "Pseudo Boolean Optimization by lower bound\n" + super.toString(prefix);
    }
}

