/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.ExitException;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.runtime.api.Framework;

class CompiledChainImpl
implements CompiledChain {
    protected final OperationType op;
    protected static String opId;
    protected OperationContext context;
    protected AutomationService service;
    protected Map<String, Object> compileParameters;
    protected InvokableMethod method;
    protected CompiledChainImpl next;

    CompiledChainImpl(OperationType op, Map<String, Object> args) {
        this(null, op, args);
    }

    CompiledChainImpl(CompiledChainImpl parent, OperationType op, Map<String, Object> args) {
        if (parent != null) {
            parent.next = this;
        }
        this.op = op;
        this.compileParameters = args;
        opId = op != null ? op.getId() : "null";
    }

    public final InvokableMethod method() {
        return this.method;
    }

    public final Map<String, Object> args() {
        return this.compileParameters;
    }

    public boolean initializePath(Class<?> in) {
        InvokableMethod[] methods = this.op.getMethodsMatchingInput(in);
        if (methods == null) {
            return false;
        }
        if (this.next == null) {
            this.method = methods[0];
            return true;
        }
        for (InvokableMethod m : methods) {
            Class<?> nextIn = m.getOutputType();
            if (nextIn == Void.TYPE || nextIn.equals(Object.class)) {
                nextIn = in;
            }
            if (!this.next.initializePath(nextIn)) continue;
            this.method = m;
            return true;
        }
        return false;
    }

    @OperationMethod
    public Object run() throws OperationException {
        return this.invoke(this.context);
    }

    @Override
    public Object invoke(OperationContext ctx) throws OperationException {
        try {
            return this.doInvoke(ctx);
        }
        catch (ExitException e) {
            if (e.isRollback()) {
                ctx.setRollback();
            }
            return ctx.getInput();
        }
    }

    protected Object doInvoke(OperationContext ctx) throws OperationException {
        OperationCallback callback = ctx.getChainCallback();
        callback.onOperation(ctx, this.op, this.method, this.compileParameters);
        Object out = this.method.invoke(ctx, this.compileParameters);
        ctx.setInput(out);
        if (this.next != null) {
            return this.next.invoke(ctx);
        }
        return out;
    }

    public String toString() {
        return "CompiledChainImpl [op=" + this.op + "]";
    }

    public static CompiledChainImpl buildChain(Class<?> in, OperationParameters[] params) throws OperationNotFoundException, InvalidChainException {
        return CompiledChainImpl.buildChain((AutomationService)Framework.getLocalService(AutomationService.class), in, params);
    }

    public static CompiledChainImpl buildChain(AutomationService service, Class<?> in, OperationParameters[] operations) throws OperationNotFoundException, InvalidChainException {
        CompiledChainImpl invocation;
        if (operations.length == 0) {
            throw new InvalidChainException("Null operation chain.");
        }
        OperationParameters params = operations[0];
        CompiledChainImpl last = invocation = new CompiledChainImpl(service.getOperation(params.id()), params.map());
        for (int i = 1; i < operations.length; ++i) {
            params = operations[i];
            last = new CompiledChainImpl(last, service.getOperation(params.id()), params.map());
        }
        if (!invocation.initializePath(in)) {
            throw new InvalidChainException("Cannot find any valid path in operation chain - no method found for operation '" + opId + "' and for first input type '" + in.getName() + "'");
        }
        return invocation;
    }
}

