/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelListCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.GetChildren", category="Document", label="Get Children", description="Get the children of a document. The list of children will become the input for the next operation")
public class GetDocumentChildren {
    public static final String ID = "Document.GetChildren";
    @Context
    protected CoreSession session;

    @OperationMethod(collector=DocumentModelListCollector.class)
    public DocumentModelList run(DocumentModel doc) {
        return this.session.getChildren(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelListCollector.class)
    public DocumentModelList run(DocumentRef doc) {
        return this.session.getChildren(doc);
    }
}

