/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="RunFileOperation", category="Execution Flow", label="Run File Chain", description="Run an operation chain which is returning a file in the current context. The input for the chain to run is a file or a list of files. Return the output of the chain as a file or a list of files. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", aliases={"Context.RunFileOperation"})
public class RunFileChain {
    public static final String ID = "RunFileOperation";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Context
    protected CoreSession session;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters;
    @Param(name="newTx", required=false, values={"false"}, description="Define if the chain in parameter should be executed in new transaction.")
    protected boolean newTx = false;
    @Param(name="timeout", required=false, description="Define transaction timeout (default to 60 sec).")
    protected Integer timeout = 60;
    @Param(name="rollbackGlobalOnError", required=false, values={"true"}, description="Define if transaction should rollback or not (default to true)")
    protected boolean rollbackGlobalOnError = true;

    @OperationMethod
    public Blob run(Blob blob) throws OperationException {
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        OperationContext subctx = this.ctx.getSubContext(this.isolate, blob);
        Blob result = null;
        result = this.newTx ? (Blob)this.service.runInNewTx(subctx, this.chainId, this.chainParameters, this.timeout, this.rollbackGlobalOnError) : (Blob)this.service.run(subctx, this.chainId, this.chainParameters);
        if (!this.isolate) {
            for (String varName : vars.keySet()) {
                if (!this.ctx.getVars().containsKey(varName)) {
                    this.ctx.put(varName, vars.get(varName));
                    continue;
                }
                Object value = vars.get(varName);
                if (this.session != null && value != null && value instanceof DocumentModel) {
                    this.ctx.getVars().put(varName, this.session.getDocument(((DocumentModel)value).getRef()));
                    continue;
                }
                this.ctx.getVars().put(varName, value);
            }
        }
        return result;
    }

    @OperationMethod
    public BlobList run(BlobList blobs) throws OperationException {
        BlobList result = new BlobList(blobs.size());
        for (Blob blob : blobs) {
            result.add(this.run(blob));
        }
        return result;
    }
}

