/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.trace.Trace;

public class Call {
    private static final Log log = LogFactory.getLog(Call.class);
    protected final String chainId;
    protected final String aliases;
    protected final OperationType type;
    protected final InvokableMethod method;
    protected final Map<String, Object> parameters;
    protected final Map<String, Object> variables;
    protected final List<Trace> nested = new LinkedList<Trace>();
    protected final Object input;

    public Call(OperationType chain, OperationContext context, OperationType type, InvokableMethod method, Map<String, Object> parms) {
        this.type = type;
        this.variables = context != null ? new HashMap<String, Object>(context) : null;
        this.method = method;
        this.input = context != null ? context.getInput() : null;
        this.parameters = new HashMap<String, Object>();
        if (parms != null) {
            for (String paramId : parms.keySet()) {
                Object paramValue = parms.get(paramId);
                if (paramValue instanceof Expression) {
                    try {
                        ExpressionParameter expressionParameter = new ExpressionParameter(paramId, ((Expression)paramValue).eval(context));
                        this.parameters.put(paramId, expressionParameter);
                    }
                    catch (RuntimeException e) {
                        log.warn((Object)("Cannot evaluate mvel expression for parameter: " + paramId), (Throwable)e);
                    }
                    continue;
                }
                this.parameters.put(paramId, paramValue);
            }
        }
        this.chainId = chain != null ? chain.getId() : "Not bound to a chain";
        this.aliases = chain != null ? Arrays.toString(chain.getAliases()) : null;
    }

    public OperationType getType() {
        return this.type;
    }

    public InvokableMethod getMethod() {
        return this.method;
    }

    public Map<String, Object> getParmeters() {
        return this.parameters;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Object getInput() {
        return this.input;
    }

    public List<Trace> getNested() {
        return this.nested;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getAliases() {
        return this.aliases;
    }

    public class ExpressionParameter {
        protected final String parameterId;
        protected final Object parameterValue;

        public ExpressionParameter(String parameterId, Object parameterValue) {
            this.parameterId = parameterId;
            this.parameterValue = parameterValue;
        }

        public Object getParameterValue() {
            return this.parameterValue;
        }

        public String getParameterId() {
            return this.parameterId;
        }
    }
}

