/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.automation.core.util.DateTimeFormat;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;

public class JSONPropertyWriter {
    private JSONPropertyWriter() {
    }

    public static void writePropertyValue(JsonGenerator jg, Property prop, DateTimeFormat dateTimeFormat, String filesBaseUrl) throws PropertyException, JsonGenerationException, IOException {
        if (prop.isScalar()) {
            JSONPropertyWriter.writeScalarPropertyValue(jg, prop, dateTimeFormat);
        } else if (prop.isList()) {
            JSONPropertyWriter.writeListPropertyValue(jg, prop, dateTimeFormat, filesBaseUrl);
        } else if (prop.isPhantom()) {
            jg.writeNull();
        } else if (prop instanceof BlobProperty) {
            JSONPropertyWriter.writeBlobPropertyValue(jg, prop, filesBaseUrl);
        } else {
            JSONPropertyWriter.writeMapPropertyValue(jg, (ComplexProperty)prop, dateTimeFormat, filesBaseUrl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void writeScalarPropertyValue(JsonGenerator jg, Property prop, DateTimeFormat dateTimeFormat) throws PropertyException, IOException {
        Type type = prop.getType();
        Serializable v = prop.getValue();
        if (v == null) {
            jg.writeNull();
            return;
        } else if (type instanceof BooleanType) {
            jg.writeBoolean(((Boolean)v).booleanValue());
            return;
        } else if (type instanceof LongType) {
            jg.writeNumber(((Long)v).longValue());
            return;
        } else if (type instanceof DoubleType) {
            jg.writeNumber(((Double)v).doubleValue());
            return;
        } else if (type instanceof IntegerType) {
            jg.writeNumber(((Integer)v).intValue());
            return;
        } else if (type instanceof BinaryType) {
            jg.writeBinary((byte[])v);
            return;
        } else if (type instanceof DateType && dateTimeFormat == DateTimeFormat.TIME_IN_MILLIS) {
            if (v instanceof Date) {
                jg.writeNumber(((Date)v).getTime());
                return;
            } else {
                if (!(v instanceof Calendar)) throw new PropertyException("Unknown class for DateType: " + v.getClass().getName() + ", " + v);
                jg.writeNumber(((Calendar)v).getTimeInMillis());
            }
            return;
        } else {
            jg.writeString(type.encode((Object)v));
        }
    }

    protected static void writeListPropertyValue(JsonGenerator jg, Property prop, DateTimeFormat dateTimeFormat, String filesBaseUrl) throws PropertyException, JsonGenerationException, IOException {
        jg.writeStartArray();
        if (prop instanceof ArrayProperty) {
            Object[] ar = (Object[])prop.getValue();
            if (ar == null) {
                jg.writeEndArray();
                return;
            }
            Type type = ((ListType)prop.getType()).getFieldType();
            for (Object o : ar) {
                jg.writeString(type.encode(o));
            }
        } else {
            ListProperty listp = (ListProperty)prop;
            for (Property p : listp.getChildren()) {
                JSONPropertyWriter.writePropertyValue(jg, p, dateTimeFormat, filesBaseUrl);
            }
        }
        jg.writeEndArray();
    }

    protected static void writeMapPropertyValue(JsonGenerator jg, ComplexProperty prop, DateTimeFormat dateTimeFormat, String filesBaseUrl) throws JsonGenerationException, IOException, PropertyException {
        jg.writeStartObject();
        for (Property p : prop.getChildren()) {
            jg.writeFieldName(p.getName());
            JSONPropertyWriter.writePropertyValue(jg, p, dateTimeFormat, filesBaseUrl);
        }
        jg.writeEndObject();
    }

    protected static void writeBlobPropertyValue(JsonGenerator jg, Property prop, String filesBaseUrl) throws PropertyException, JsonGenerationException, IOException {
        Blob blob = (Blob)prop.getValue();
        if (blob == null) {
            jg.writeNull();
            return;
        }
        jg.writeStartObject();
        String v = blob.getFilename();
        if (v == null) {
            jg.writeNullField("name");
        } else {
            jg.writeStringField("name", v);
        }
        v = blob.getMimeType();
        if (v == null) {
            jg.writeNullField("mime-type");
        } else {
            jg.writeStringField("mime-type", v);
        }
        v = blob.getEncoding();
        if (v == null) {
            jg.writeNullField("encoding");
        } else {
            jg.writeStringField("encoding", v);
        }
        v = blob.getDigest();
        if (v == null) {
            jg.writeNullField("digest");
        } else {
            jg.writeStringField("digest", v);
        }
        jg.writeStringField("length", Long.toString(blob.getLength()));
        if (filesBaseUrl != null) {
            jg.writeStringField("data", JSONPropertyWriter.getBlobUrl(prop, filesBaseUrl));
        }
        jg.writeEndObject();
    }

    private static String getBlobUrl(Property prop, String filesBaseUrl) throws UnsupportedEncodingException, PropertyException {
        StringBuilder blobUrlBuilder = new StringBuilder(filesBaseUrl);
        blobUrlBuilder.append(prop.getSchema().getName());
        blobUrlBuilder.append(":");
        String canonicalXPath = ComplexTypeImpl.canonicalXPath((String)prop.getPath().substring(1));
        blobUrlBuilder.append(canonicalXPath);
        blobUrlBuilder.append("/");
        String filename = ((Blob)prop.getValue()).getFilename();
        if (filename != null) {
            blobUrlBuilder.append(URIUtils.quoteURIPathComponent((String)filename, (boolean)true));
        }
        return blobUrlBuilder.toString();
    }
}

