/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.Xml2TextHandler;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.XmlZip2TextConverter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class BaseOfficeXMLTextConverter
implements Converter {
    public static final String MAX_SIZE = "MAX_SIZE";
    protected long maxSize4POI = 5191680L;

    protected BlobHolder runFallBackConverter(BlobHolder blobHolder, final String prefix) throws ConversionException {
        XmlZip2TextConverter fallback = new XmlZip2TextConverter(){

            @Override
            protected void readXmlZipContent(ZipInputStream zis, XMLReader reader, StringBuilder sb) throws IOException, SAXException {
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    if (zipEntry.getName().startsWith(prefix) && zipEntry.getName().endsWith(".xml")) {
                        try {
                            Xml2TextHandler xml2text = new Xml2TextHandler();
                            sb.append(xml2text.parse(new InputSource(zis)));
                        }
                        catch (ParserConfigurationException e) {
                            throw new IOException("Error during raw XML Text extraction", e);
                        }
                    }
                    zipEntry = zis.getNextEntry();
                }
            }
        };
        return fallback.convert(blobHolder, new HashMap());
    }

    public void init(ConverterDescriptor descriptor) {
        String max = (String)descriptor.getParameters().get(MAX_SIZE);
        if (max != null) {
            this.maxSize4POI = Long.parseLong(max);
        }
    }
}

