/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class UserManagerResolver
implements ObjectResolver {
    private static final long serialVersionUID = 1L;
    public static final String INPUT_PARAM_FILTER = "type";
    public static final String FILTER_GROUP = "group";
    public static final String FILTER_USER = "user";
    public static final String NAME = "userManagerResolver";
    public static final String PARAM_INCLUDE_USERS = "includeUsers";
    public static final String PARAM_INCLUDE_GROUPS = "includeGroups";
    private Map<String, Serializable> parameters;
    private boolean includingUsers = true;
    private boolean includingGroups = true;
    private transient UserManager userManager;
    private List<Class<?>> managedClasses = null;

    public UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)Framework.getService(UserManager.class);
        }
        return this.userManager;
    }

    public List<Class<?>> getManagedClasses() {
        if (this.managedClasses == null) {
            this.managedClasses = new ArrayList();
            if (this.includingUsers) {
                this.managedClasses.add(NuxeoPrincipal.class);
            }
            if (this.includingGroups) {
                this.managedClasses.add(NuxeoGroup.class);
            }
        }
        return this.managedClasses;
    }

    public void configure(Map<String, String> parameters) throws IllegalStateException {
        if (this.parameters != null) {
            throw new IllegalStateException("cannot change configuration, may be already in use somewhere");
        }
        if (FILTER_USER.equals(parameters.get(INPUT_PARAM_FILTER))) {
            this.includingGroups = false;
        } else if (FILTER_GROUP.equals(parameters.get(INPUT_PARAM_FILTER))) {
            this.includingUsers = false;
        }
        this.parameters = new HashMap<String, Serializable>();
        this.parameters.put(PARAM_INCLUDE_GROUPS, Boolean.valueOf(this.includingGroups));
        this.parameters.put(PARAM_INCLUDE_USERS, Boolean.valueOf(this.includingUsers));
    }

    public String getName() throws IllegalStateException {
        this.checkConfig();
        return NAME;
    }

    public Map<String, Serializable> getParameters() throws IllegalStateException {
        this.checkConfig();
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean validate(Object value) throws IllegalStateException {
        this.checkConfig();
        return this.fetch(value) != null;
    }

    public Object fetch(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value != null && value instanceof String) {
            String name = (String)value;
            boolean userPrefix = name.startsWith("user:");
            boolean groupPrefix = name.startsWith("group:");
            if (this.includingUsers && !this.includingGroups) {
                if (userPrefix) {
                    name = name.substring("user:".length());
                }
                if ("system".equals(name)) {
                    return new SystemPrincipal(name);
                }
                return this.getUserManager().getPrincipal(name);
            }
            if (!this.includingUsers && this.includingGroups) {
                if (groupPrefix) {
                    name = name.substring("group:".length());
                }
                return this.getUserManager().getGroup(name);
            }
            if (userPrefix) {
                if ("system".equals(name = name.substring("user:".length()))) {
                    return new SystemPrincipal(name);
                }
                return this.getUserManager().getPrincipal(name);
            }
            if (groupPrefix) {
                name = name.substring("group:".length());
                return this.getUserManager().getGroup(name);
            }
            if ("system".equals(name)) {
                return new SystemPrincipal(name);
            }
            NuxeoPrincipal principal = this.getUserManager().getPrincipal(name);
            if (principal != null) {
                return principal;
            }
            return this.getUserManager().getGroup(name);
        }
        return null;
    }

    public <T> T fetch(Class<T> type, Object value) throws IllegalStateException {
        this.checkConfig();
        Object principal = this.fetch(value);
        if (type.isInstance(principal)) {
            return (T)principal;
        }
        return null;
    }

    public Serializable getReference(Object entity) throws IllegalStateException {
        this.checkConfig();
        if (entity != null) {
            if (entity instanceof NuxeoPrincipal && this.includingUsers) {
                return "user:" + ((NuxeoPrincipal)entity).getName();
            }
            if (entity instanceof NuxeoGroup && this.includingGroups) {
                return "group:" + ((NuxeoGroup)entity).getName();
            }
        }
        return null;
    }

    public String getConstraintErrorMessage(Object invalidValue, Locale locale) throws IllegalStateException {
        this.checkConfig();
        if (this.isIncludingUsers() && this.isIncludingGroups()) {
            return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (String)"any", (Object)invalidValue, (Locale)locale, (String[])new String[0]);
        }
        if (!this.isIncludingUsers() && this.isIncludingGroups()) {
            return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (String)FILTER_GROUP, (Object)invalidValue, (Locale)locale, (String[])new String[0]);
        }
        if (this.isIncludingUsers() && !this.isIncludingGroups()) {
            return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (String)FILTER_USER, (Object)invalidValue, (Locale)locale, (String[])new String[0]);
        }
        return String.format("%s cannot resolve reference %s", this.getName(), invalidValue);
    }

    public boolean isIncludingUsers() throws IllegalStateException {
        this.checkConfig();
        return this.includingUsers;
    }

    public boolean isIncludingGroups() throws IllegalStateException {
        this.checkConfig();
        return this.includingGroups;
    }

    private void checkConfig() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("you should call #configure(Map<String, String>) before. Please get this resolver throught ExternalReferenceService which is in charge of resolver configuration.");
        }
    }
}

