/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoPrincipalJsonWriter
extends ExtensibleEntityJsonWriter<NuxeoPrincipal> {
    public static final String ENTITY_TYPE = "user";
    @Inject
    private UserManager userManager;
    @Inject
    private DirectoryService directoryService;

    public NuxeoPrincipalJsonWriter() {
        super(ENTITY_TYPE, NuxeoPrincipal.class);
    }

    protected void writeEntityBody(NuxeoPrincipal principal, JsonGenerator jg) throws IOException {
        jg.writeStringField("id", principal.getName());
        this.writeProperties(jg, principal);
        this.writeExtendedGroups(jg, principal);
        jg.writeBooleanField("isAdministrator", principal.isAdministrator());
        jg.writeBooleanField("isAnonymous", principal.isAnonymous());
    }

    private void writeProperties(JsonGenerator jg, NuxeoPrincipal principal) throws IOException {
        DocumentModel doc = principal.getModel();
        if (doc == null) {
            return;
        }
        String userSchema = this.userManager.getUserSchemaName();
        DocumentPart userPart = doc.getPart(userSchema);
        if (userPart == null) {
            return;
        }
        Writer propertyWriter = this.registry.getWriter(this.ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
        jg.writeObjectFieldStart("properties");
        for (Property property : userPart.getChildren()) {
            String localName = property.getField().getName().getLocalName();
            jg.writeFieldName(localName);
            if (localName.equals(this.getPasswordField())) {
                jg.writeString("");
                continue;
            }
            OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
            propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
        }
        jg.writeEndObject();
    }

    private void writeExtendedGroups(JsonGenerator jg, NuxeoPrincipal principal) throws IOException {
        jg.writeArrayFieldStart("extendedGroups");
        for (String strGroup : principal.getAllGroups()) {
            NuxeoGroup group = this.userManager.getGroup(strGroup);
            String label = group == null ? strGroup : group.getLabel();
            jg.writeStartObject();
            jg.writeStringField("name", strGroup);
            jg.writeStringField("label", label);
            jg.writeStringField("url", "group/" + strGroup);
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private String getPasswordField() {
        String userDirectoryName = this.userManager.getUserDirectoryName();
        return this.directoryService.getDirectory(userDirectoryName).getPasswordField();
    }
}

