/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.clipboard;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PropertyException;

public class SummaryEntry
implements Comparable<SummaryEntry>,
Serializable {
    private static final long serialVersionUID = -9090607163794413025L;
    private String marker = " ";
    private String bullet = "* ";
    private String pathSeparator = "/";
    private String fileSeparator = " -> ";
    private String versionSepartor = "_";
    private String dateSeparator = " - ";
    private String cr = "\n";
    private String uuid;
    private DocumentRef documentRef;
    private String title;
    private String modifiedDate;
    private String filename;
    private String version;
    private SummaryEntry parent;

    public SummaryEntry(String uuid, String title, String modifiedDate, String filename, String version) {
        this.uuid = uuid;
        this.title = title;
        this.modifiedDate = modifiedDate;
        this.filename = filename;
        this.version = version;
    }

    public SummaryEntry(String uuid, String title, Date modifiedDate, String filename, String version, SummaryEntry parent) {
        this.uuid = uuid;
        this.title = title;
        if (modifiedDate != null) {
            this.modifiedDate = SummaryEntry.getDateFormat().format(modifiedDate);
        }
        this.filename = filename;
        this.version = version;
        this.parent = parent;
    }

    public SummaryEntry(DocumentModel doc) {
        Object date;
        Object minor;
        Object major;
        this.uuid = doc.getRef().toString();
        try {
            this.title = (String)doc.getProperty("dublincore", "title");
        }
        catch (PropertyException e) {
            this.title = null;
        }
        this.documentRef = doc.getRef();
        try {
            major = doc.getProperty("uid", "major_version");
        }
        catch (PropertyException e) {
            major = null;
        }
        try {
            minor = doc.getProperty("uid", "minor_version");
        }
        catch (PropertyException e) {
            minor = null;
        }
        try {
            date = doc.getProperty("dublincore", "modified");
        }
        catch (PropertyException e) {
            date = null;
        }
        if (major != null && minor != null) {
            this.version = major.toString() + '.' + minor.toString();
        }
        if (date != null) {
            this.modifiedDate = SummaryEntry.getDateFormat().format(((Calendar)date).getTime());
        }
        try {
            this.filename = (String)doc.getProperty("file", "filename");
        }
        catch (PropertyException e) {
            this.filename = null;
        }
    }

    public SummaryEntry(DocumentRef reference) {
        this.documentRef = reference;
    }

    public SummaryEntry() {
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toFlatString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cr);
        sb.append(this.marker);
        sb.append(this.getPath());
        if (this.filename != null && !"".equals(this.filename)) {
            sb.append(this.fileSeparator);
            sb.append(this.filename);
        }
        if (this.version != null && !"".equals(this.version)) {
            sb.append(this.versionSepartor);
            sb.append(this.version);
        }
        if (this.modifiedDate != null && !"".equals(this.modifiedDate)) {
            sb.append(this.dateSeparator);
            sb.append(this.modifiedDate);
        }
        return sb.toString();
    }

    public String toTreeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cr);
        sb.append(this.marker);
        sb.append(this.bullet);
        sb.append(this.title);
        if (this.filename != null && !"".equals(this.filename)) {
            sb.append(this.fileSeparator);
            sb.append(this.filename);
        }
        if (this.version != null && !"".equals(this.version)) {
            sb.append(this.versionSepartor);
            sb.append(this.version);
        }
        if (this.modifiedDate != null && !"".equals(this.modifiedDate)) {
            sb.append(this.dateSeparator);
            sb.append(this.modifiedDate);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toFlatString();
    }

    public SummaryEntry getParent() {
        return this.parent;
    }

    public void setParent(SummaryEntry parent) {
        this.parent = parent;
    }

    public void setParent(DocumentRef parentRef) {
        this.parent = new SummaryEntry(parentRef);
    }

    public DocumentRef getDocumentRef() {
        return this.documentRef;
    }

    public void setDocumentRef(DocumentRef documentRef) {
        this.documentRef = documentRef;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SummaryEntry)) {
            return false;
        }
        return this.documentRef.equals(((SummaryEntry)obj).documentRef) && this.getPath().equals(((SummaryEntry)obj).getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public static List<SummaryEntry> getPathList(List<SummaryEntry> pathList, SummaryEntry parentEntry) {
        if (pathList == null) {
            pathList = new ArrayList<SummaryEntry>();
        }
        if (parentEntry != null) {
            pathList.add(parentEntry);
            if (parentEntry.parent != null) {
                SummaryEntry.getPathList(pathList, parentEntry.parent);
            }
        }
        return pathList;
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        List<SummaryEntry> pathList = SummaryEntry.getPathList(null, this);
        Collections.reverse(pathList);
        int i = 0;
        for (SummaryEntry entry : pathList) {
            sb.append(entry.title);
            if (i < pathList.size() - 1) {
                sb.append('/');
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int compareTo(SummaryEntry o) {
        if (o != null) {
            return this.getPath().compareTo(o.getPath());
        }
        return 0;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getBullet() {
        return this.bullet;
    }

    public void setBullet(String bullet) {
        this.bullet = bullet;
    }

    public String getCr() {
        return this.cr;
    }

    public void setCr(String cr) {
        this.cr = cr;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public String getVersionSepartor() {
        return this.versionSepartor;
    }

    public void setVersionSepartor(String versionSepartor) {
        this.versionSepartor = versionSepartor;
    }

    public String getDateSeparator() {
        return this.dateSeparator;
    }

    public void setDateSeparator(String dateSeparator) {
        this.dateSeparator = dateSeparator;
    }
}

