/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.webapp.security.AbstractUserGroupManagement;

@Name(value="groupManagementActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class GroupManagementActions
extends AbstractUserGroupManagement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GroupManagementActions.class);
    public static final String GROUPS_TAB = "USER_CENTER:UsersGroupsHome:GroupsHome";
    public static final String GROUPS_LISTING_CHANGED = "groupsListingChanged";
    protected Boolean canEditGroups;
    protected DocumentModel selectedGroup;
    protected DocumentModel newGroup;
    protected boolean createAnotherGroup = false;

    @Override
    protected String computeListingMode() {
        return this.userManager.getGroupListingMode();
    }

    public DocumentModel getSelectedGroup() {
        this.shouldResetStateOnTabChange = true;
        return this.selectedGroup;
    }

    public String getSelectedGroupName() {
        return this.selectedGroup.getId();
    }

    public void setSelectedGroupName(String groupName) {
        this.setSelectedGroup(groupName);
    }

    public void setShowGroup(String showGroup) {
        this.showUserOrGroup = Boolean.valueOf(showGroup);
    }

    public void setSelectedGroup(String groupName) {
        this.selectedGroup = this.refreshGroup(groupName);
    }

    protected DocumentModel refreshGroup(String groupName) {
        return this.userManager.getGroupModel(groupName);
    }

    public DocumentModel getNewGroup() {
        if (this.newGroup == null) {
            this.newGroup = this.userManager.getBareGroupModel();
        }
        return this.newGroup;
    }

    public void clearSearch() {
        this.searchString = null;
        this.fireSeamEvent(GROUPS_LISTING_CHANGED);
    }

    public void createGroup() {
        try {
            this.selectedGroup = this.userManager.createGroup(this.newGroup);
            this.newGroup = null;
            this.facesMessages.add(StatusMessage.Severity.INFO, this.resourcesAccessor.getMessages().get("info.groupManager.groupCreated"), new Object[0]);
            if (this.createAnotherGroup) {
                this.showCreateForm = true;
            } else {
                this.showCreateForm = false;
                this.showUserOrGroup = true;
                this.detailsMode = null;
            }
            this.fireSeamEvent(GROUPS_LISTING_CHANGED);
        }
        catch (GroupAlreadyExistsException e) {
            String message = this.resourcesAccessor.getMessages().get("error.groupManager.groupAlreadyExists");
            this.facesMessages.addToControl("groupName", StatusMessage.Severity.ERROR, message, new Object[0]);
        }
    }

    public void updateGroup() {
        this.userManager.updateGroup(this.selectedGroup);
        this.detailsMode = "view";
        this.fireSeamEvent(GROUPS_LISTING_CHANGED);
    }

    public void deleteGroup() {
        this.userManager.deleteGroup(this.selectedGroup);
        this.selectedGroup = null;
        this.showUserOrGroup = false;
        this.fireSeamEvent(GROUPS_LISTING_CHANGED);
    }

    public boolean getAllowCreateGroup() {
        return this.getCanEditGroups();
    }

    protected boolean getCanEditGroups() {
        if (this.canEditGroups == null) {
            this.canEditGroups = false;
            if (!this.userManager.areGroupsReadOnly().booleanValue() && this.currentUser instanceof NuxeoPrincipal && this.webActions.checkFilter("usersGroupsManagementAccess")) {
                this.canEditGroups = true;
            }
        }
        return this.canEditGroups;
    }

    public boolean getAllowDeleteGroup() {
        if (this.getAllAdminGroups().contains(this.selectedGroup.getId())) {
            return ((NuxeoPrincipal)this.currentUser).isAdministrator();
        }
        return this.getCanEditGroups() && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedGroup);
    }

    public boolean getAllowEditGroup() {
        if (this.getAllAdminGroups().contains(this.selectedGroup.getId())) {
            return ((NuxeoPrincipal)this.currentUser).isAdministrator();
        }
        return this.getCanEditGroups() && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedGroup);
    }

    public void validateGroupName(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || !StringUtils.containsOnly((String)((String)value), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789.@")) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.groupManager.wrongGroupName"), null);
            ((EditableValueHolder)component).setValid(false);
            context.addMessage(component.getClientId(context), message);
            context.addMessage(null, message);
        }
    }

    public String viewGroup() {
        if (this.selectedGroup != null) {
            return this.viewGroup(this.selectedGroup.getId());
        }
        return null;
    }

    public String viewGroup(String groupName) {
        this.webActions.setCurrentTabIds("MAIN_TABS:home,USER_CENTER:UsersGroupsHome:GroupsHome");
        this.setSelectedGroup(groupName);
        this.showUserOrGroup = true;
        this.shouldResetStateOnTabChange = false;
        return "view_home";
    }

    protected void fireSeamEvent(String eventName) {
        Events evtManager = Events.instance();
        evtManager.raiseEvent(eventName, new Object[0]);
    }

    @Observer(value={"groupsListingChanged"})
    public void onUsersListingChanged() {
        this.contentViewActions.refreshOnSeamEvent(GROUPS_LISTING_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(GROUPS_LISTING_CHANGED);
    }

    @Observer(value={"currentTabChanged_MAIN_TABS", "currentTabChanged_NUXEO_ADMIN", "currentTabChanged_USER_CENTER", "currentTabChanged_UsersGroupsManager_sub_tab", "currentTabChanged_UsersGroupsHome_sub_tab", "currentTabSelected_MAIN_TABS", "currentTabSelected_NUXEO_ADMIN", "currentTabSelected_USER_CENTER", "currentTabSelected_UsersGroupsManager_sub_tab", "currentTabSelected_UsersGroupsHome_sub_tab"}, create=false)
    public void resetState() {
        if (this.shouldResetStateOnTabChange) {
            this.newGroup = null;
            this.showUserOrGroup = false;
            this.showCreateForm = false;
            this.detailsMode = "view";
        }
    }

    public boolean isCreateAnotherGroup() {
        return this.createAnotherGroup;
    }

    public void setCreateAnotherGroup(boolean createAnotherGroup) {
        this.createAnotherGroup = createAnotherGroup;
    }
}

