/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.wro.processor.AbstractFlavorProcessor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;

@SupportedResourceType(value=ResourceType.CSS)
public class FlavorResourceProcessor
extends AbstractFlavorProcessor {
    private static final Log log = LogFactory.getLog(FlavorResourceProcessor.class);
    public static final String ALIAS = "flavor";

    @Override
    protected void process(Resource resource, Reader reader, Writer writer, String flavorName) throws IOException {
        ProxyInputStream is = new ProxyInputStream((InputStream)new ReaderInputStream(reader, this.getEncoding())){};
        ProxyOutputStream os = new ProxyOutputStream((OutputStream)new WriterOutputStream(writer, this.getEncoding()));
        try {
            Map presets = null;
            if (flavorName != null) {
                ThemeStylingService s = (ThemeStylingService)Framework.getService(ThemeStylingService.class);
                presets = s.getPresetVariables(flavorName);
            }
            if (presets == null || presets.isEmpty()) {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            } else {
                String content = IOUtils.toString((Reader)reader);
                for (Map.Entry preset : presets.entrySet()) {
                    content = Pattern.compile(String.format("\"%s\"", preset.getKey()), 16).matcher(content).replaceAll(Matcher.quoteReplacement((String)preset.getValue()));
                }
                writer.write(content);
                writer.flush();
            }
            is.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while serving resource " + resource.getUri()), (Throwable)e);
            throw WroRuntimeException.wrap((Exception)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }
}

