/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.cache.CacheRegistry;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class CacheServiceImpl
extends DefaultComponent
implements CacheService {
    public static final ComponentName NAME = new ComponentName(CacheServiceImpl.class.getName());
    private static final Log log = LogFactory.getLog(CacheServiceImpl.class);
    protected final CacheRegistry cacheRegistry = new CacheRegistry();

    @Override
    public CacheAttributesChecker getCache(String name) {
        return this.cacheRegistry.getCache(name);
    }

    public void deactivate(ComponentContext context) {
        if (this.cacheRegistry.caches.size() > 0) {
            HashMap<String, CacheDescriptor> descriptors = new HashMap<String, CacheDescriptor>(this.cacheRegistry.caches);
            for (CacheDescriptor desc : descriptors.values()) {
                log.warn((Object)("Unregistery leaked contribution " + desc.name));
                this.cacheRegistry.contributionRemoved(desc.name, desc);
            }
        }
    }

    public void applicationStarted(ComponentContext context) {
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (0 != event.id) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                CacheServiceImpl.this.cacheRegistry.stop();
            }
        });
        this.cacheRegistry.start();
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            CacheDescriptor descriptor = (CacheDescriptor)contrib;
            this.registerCache(descriptor);
        }
    }

    public void registerCache(CacheDescriptor descriptor) {
        this.cacheRegistry.addContribution(descriptor);
    }

    public void unregisterExtension(Extension extension) throws RuntimeException {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            CacheDescriptor descriptor = (CacheDescriptor)contrib;
            this.cacheRegistry.removeContribution(descriptor);
        }
    }

    public void unregisterCache(CacheDescriptor descriptor) {
        this.cacheRegistry.removeContribution(descriptor);
    }
}

