/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore.work;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.runtime.api.Framework;

public abstract class TransientStoreWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final String STORE_NAME = "transientStoreWorkCache";
    public static final String KEY_SUFFIX = "_result";
    protected String entryKey;

    public static void putBlobHolder(String key, BlobHolder bh) {
        TransientStoreWork.getStore().putBlobs(key, bh.getBlobs());
        Map properties = bh.getProperties();
        if (properties != null) {
            TransientStoreWork.getStore().putParameters(key, properties);
        }
    }

    public static BlobHolder getBlobHolder(String key) {
        List<Blob> blobs = TransientStoreWork.getStore().getBlobs(key);
        Map<String, Serializable> params = TransientStoreWork.getStore().getParameters(key);
        if (blobs == null && params == null) {
            return null;
        }
        return new SimpleBlobHolderWithProperties(blobs, params);
    }

    public static void removeBlobHolder(String key) {
        TransientStoreWork.getStore().remove(key);
    }

    protected static TransientStore getStore() {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        return transientStoreService.getStore(STORE_NAME);
    }

    public TransientStoreWork() {
        this.computeEntryKey();
    }

    public TransientStoreWork(String id) {
        super(id);
        this.computeEntryKey();
    }

    protected void computeEntryKey() {
        this.entryKey = this.getId() + KEY_SUFFIX;
    }

    protected void putBlobHolder(BlobHolder bh) {
        TransientStoreWork.putBlobHolder(this.entryKey, bh);
    }

    public String getWorkInstanceResult() {
        return this.entryKey;
    }
}

