/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.DefaultVersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.ExtendableVersioningService;
import org.nuxeo.ecm.core.versioning.StandardVersioningService;
import org.nuxeo.ecm.core.versioning.VersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.core.versioning.VersioningServiceDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class VersioningComponent
extends DefaultComponent
implements VersioningService {
    private static final Log log = LogFactory.getLog(VersioningComponent.class);
    public static final String VERSIONING_SERVICE_XP = "versioningService";
    public static final String VERSIONING_RULE_XP = "versioningRules";
    protected static final StandardVersioningService STANDARD_VERSIONING_SERVICE = new StandardVersioningService();
    protected Map<VersioningServiceDescriptor, VersioningService> versioningServices = new LinkedHashMap<VersioningServiceDescriptor, VersioningService>();
    protected VersioningRuleRegistry versioningRulesRegistry = new VersioningRuleRegistry();
    protected Deque<DefaultVersioningRuleDescriptor> defaultVersioningRuleList = new ArrayDeque<DefaultVersioningRuleDescriptor>();
    public VersioningService service = STANDARD_VERSIONING_SERVICE;
    protected ComponentContext context;

    public void activate(ComponentContext context) {
        this.context = context;
    }

    public void deactivate(ComponentContext context) {
        this.context = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerContribution(Object contrib, String point, ComponentInstance contributor) {
        if (VERSIONING_SERVICE_XP.equals(point)) {
            this.registerVersioningService((VersioningServiceDescriptor)contrib);
            return;
        } else {
            if (!VERSIONING_RULE_XP.equals(point)) throw new RuntimeException("Unknown extension point: " + point);
            if (contrib instanceof VersioningRuleDescriptor) {
                this.registerVersioningRule((VersioningRuleDescriptor)contrib);
                return;
            } else {
                if (!(contrib instanceof DefaultVersioningRuleDescriptor)) throw new RuntimeException("Unknown contribution to " + point + ": " + contrib.getClass());
                this.registerDefaultVersioningRule((DefaultVersioningRuleDescriptor)contrib);
            }
        }
    }

    public void unregisterContribution(Object contrib, String point, ComponentInstance contributor) {
        if (VERSIONING_SERVICE_XP.equals(point)) {
            this.unregisterVersioningService((VersioningServiceDescriptor)contrib);
        } else if (VERSIONING_RULE_XP.equals(point)) {
            if (contrib instanceof VersioningRuleDescriptor) {
                this.unregisterVersioningRule((VersioningRuleDescriptor)contrib);
            } else if (contrib instanceof DefaultVersioningRuleDescriptor) {
                this.unregisterDefaultVersioningRule((DefaultVersioningRuleDescriptor)contrib);
            }
        }
    }

    protected void registerVersioningService(VersioningServiceDescriptor contrib) {
        String klass = contrib.className;
        try {
            VersioningService vs = (VersioningService)this.context.getRuntimeContext().loadClass(klass).newInstance();
            this.versioningServices.put(contrib, vs);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate: " + klass, e);
        }
        log.info((Object)("Registered versioning service: " + klass));
        this.recompute();
    }

    protected void unregisterVersioningService(VersioningServiceDescriptor contrib) {
        this.versioningServices.remove(contrib);
        log.info((Object)("Unregistered versioning service: " + contrib.className));
        this.recompute();
    }

    protected void registerVersioningRule(VersioningRuleDescriptor contrib) {
        this.versioningRulesRegistry.addContribution(contrib);
        log.info((Object)("Registered versioning rule: " + contrib.getTypeName()));
        this.recompute();
    }

    protected void unregisterVersioningRule(VersioningRuleDescriptor contrib) {
        this.versioningRulesRegistry.removeContribution(contrib);
        log.info((Object)("Unregistered versioning rule: " + contrib.getTypeName()));
        this.recompute();
    }

    protected void registerDefaultVersioningRule(DefaultVersioningRuleDescriptor contrib) {
        this.defaultVersioningRuleList.add(contrib);
        this.recompute();
    }

    protected void unregisterDefaultVersioningRule(DefaultVersioningRuleDescriptor contrib) {
        this.defaultVersioningRuleList.remove(contrib);
        this.recompute();
    }

    protected void recompute() {
        VersioningService versioningService = STANDARD_VERSIONING_SERVICE;
        for (VersioningService vs : this.versioningServices.values()) {
            versioningService = vs;
        }
        if (versioningService instanceof ExtendableVersioningService) {
            ExtendableVersioningService vs = versioningService;
            vs.setVersioningRules(this.getVersioningRules());
            vs.setDefaultVersioningRule(this.getDefaultVersioningRule());
        }
        this.service = versioningService;
    }

    protected Map<String, VersioningRuleDescriptor> getVersioningRules() {
        return this.versioningRulesRegistry.getVersioningRuleDescriptors();
    }

    protected DefaultVersioningRuleDescriptor getDefaultVersioningRule() {
        return this.defaultVersioningRuleList.peekLast();
    }

    @Override
    public String getVersionLabel(DocumentModel doc) {
        return this.service.getVersionLabel(doc);
    }

    @Override
    public void doPostCreate(Document doc, Map<String, Serializable> options) {
        this.service.doPostCreate(doc, options);
    }

    @Override
    public List<VersioningOption> getSaveOptions(DocumentModel docModel) {
        return this.service.getSaveOptions(docModel);
    }

    @Override
    public boolean isPreSaveDoingCheckOut(Document doc, boolean isDirty, VersioningOption option, Map<String, Serializable> options) {
        return this.service.isPreSaveDoingCheckOut(doc, isDirty, option, options);
    }

    @Override
    public VersioningOption doPreSave(Document doc, boolean isDirty, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        return this.service.doPreSave(doc, isDirty, option, checkinComment, options);
    }

    @Override
    public boolean isPostSaveDoingCheckIn(Document doc, VersioningOption option, Map<String, Serializable> options) {
        return this.service.isPostSaveDoingCheckIn(doc, option, options);
    }

    @Override
    public Document doPostSave(Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        return this.service.doPostSave(doc, option, checkinComment, options);
    }

    @Override
    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) {
        return this.service.doCheckIn(doc, option, checkinComment);
    }

    @Override
    public void doCheckOut(Document doc) {
        this.service.doCheckOut(doc);
    }

    protected static class VersioningRuleRegistry
    extends SimpleContributionRegistry<VersioningRuleDescriptor> {
        protected VersioningRuleRegistry() {
        }

        public String getContributionId(VersioningRuleDescriptor contrib) {
            return contrib.getTypeName();
        }

        public VersioningRuleDescriptor clone(VersioningRuleDescriptor orig) {
            return new VersioningRuleDescriptor(orig);
        }

        public void merge(VersioningRuleDescriptor src, VersioningRuleDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void contributionUpdated(String id, VersioningRuleDescriptor contrib, VersioningRuleDescriptor newOrigContrib) {
            if (contrib.isEnabled()) {
                this.currentContribs.put(id, contrib);
            } else {
                this.currentContribs.remove(id);
            }
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public Map<String, VersioningRuleDescriptor> getVersioningRuleDescriptors() {
            return this.currentContribs;
        }
    }
}

