/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.JavaTypes;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;

public class ArrayProperty
extends ScalarProperty {
    private static final long serialVersionUID = 0L;
    private boolean[] childDirty = null;

    public ArrayProperty(Property parent, Field field, int flags) {
        super(parent, field, flags);
    }

    public ListType getType() {
        return (ListType)super.getType();
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public void setValue(Object value) throws PropertyException {
        if (value == null) {
            this.childDirty = new boolean[0];
            super.setValue(value);
        } else {
            Object[] oldValues = (Object[])this.internalGetValue();
            boolean[] oldChildDirty = this.getChildDirty();
            super.setValue(value);
            Object[] newValues = (Object[])this.internalGetValue();
            boolean[] newChildDirty = new boolean[newValues != null ? newValues.length : 0];
            for (int i = 0; i < newChildDirty.length; ++i) {
                Object newValue = newValues[i];
                if (oldValues == null || i >= oldValues.length) {
                    newChildDirty[i] = true;
                    continue;
                }
                Object oldValue = oldValues[i];
                newChildDirty[i] = !(newValue == null && oldValue == null || newValue != null && newValue.equals(oldValue)) ? true : oldChildDirty[i];
            }
            this.childDirty = newChildDirty;
        }
    }

    @Override
    protected boolean isSameValue(Serializable value1, Serializable value2) {
        Object[] castedtValue1 = (Object[])value1;
        Object[] castedtValue2 = (Object[])value2;
        return castedtValue1 == castedtValue2 || castedtValue1 == null && castedtValue2.length == 0 || castedtValue2 == null && castedtValue1.length == 0 || Arrays.equals(castedtValue1, castedtValue2);
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value.getClass().isArray();
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            Class klass = JavaTypes.getClass((Type)this.getType().getFieldType());
            return col.toArray((Object[])Array.newInstance(klass, col.size()));
        }
        throw new PropertyConversionException(value.getClass(), Object[].class, this.getPath());
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        if (toType.isArray()) {
            return (T)PrimitiveArrays.toObjectArray((Object)value);
        }
        if (Collection.class.isAssignableFrom(toType)) {
            return (T)Arrays.asList((Object[])value);
        }
        throw new PropertyConversionException(value.getClass(), toType);
    }

    @Override
    public Object newInstance() {
        return new Serializable[0];
    }

    protected boolean[] getChildDirty() {
        if (this.childDirty == null) {
            Object[] oldValues = (Object[])this.internalGetValue();
            if (oldValues == null) {
                this.childDirty = new boolean[0];
            } else {
                this.childDirty = new boolean[oldValues.length];
                for (int i = 0; i < this.childDirty.length; ++i) {
                    this.childDirty[i] = false;
                }
            }
        }
        return this.childDirty;
    }

    public boolean isDirty(int index) {
        if (index > this.getChildDirty().length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ". Bounds are: 0 - " + (this.getChildDirty().length - 1));
        }
        return this.getChildDirty()[index];
    }

    @Override
    public void clearDirtyFlags() {
        super.clearDirtyFlags();
        for (int i = 0; i < this.getChildDirty().length; ++i) {
            this.childDirty[i] = false;
        }
    }
}

