/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.pathsegment;

import java.util.regex.Pattern;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class PathSegmentServiceDefault
implements PathSegmentService {
    public Pattern stupidRegexp = Pattern.compile("^[- .,;?!:/\\\\'\"]*$");
    public static final String NUXEO_MAX_SEGMENT_SIZE_PROPERTY = "nuxeo.path.segment.maxsize";

    @Override
    public String generatePathSegment(DocumentModel doc) {
        return this.generatePathSegment(doc.getTitle());
    }

    @Override
    public String generatePathSegment(String s) {
        if (s == null) {
            s = "";
        }
        if ((s = s.trim()).length() > this.getMaxSize()) {
            s = s.substring(0, this.getMaxSize()).trim();
        }
        s = s.replace('/', '-');
        if (this.stupidRegexp.matcher(s = s.replace('\\', '-')).matches()) {
            return IdUtils.generateStringId();
        }
        return s;
    }

    @Override
    public int getMaxSize() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        return Integer.parseInt(cs.getProperty(NUXEO_MAX_SEGMENT_SIZE_PROPERTY, "24"));
    }
}

