/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;
import org.nuxeo.ecm.platform.ui.web.binding.alias.UIAliasHolder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class AliasTagHandler
extends ComponentHandler {
    public static String ANCHOR_ENABLED_VARIABLE = "nuxeoAliasAnchorEnabled";
    protected final TagAttribute cache;
    protected final TagAttribute id = this.getAttribute("id");
    protected final Map<String, ValueExpression> variables;
    protected final List<String> blockedPatterns;
    protected final TagAttribute anchor;

    public AliasTagHandler(ComponentConfig config, Map<String, ValueExpression> variables) {
        this(config, variables, null);
    }

    public AliasTagHandler(ComponentConfig config, Map<String, ValueExpression> variables, List<String> blockedPatterns) {
        super(config);
        this.cache = this.getAttribute("cache");
        this.anchor = this.getAttribute("anchor");
        this.variables = variables;
        this.blockedPatterns = blockedPatterns;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        boolean cacheValue = false;
        if (this.cache != null) {
            cacheValue = this.cache.getBoolean(ctx);
        }
        AliasVariableMapper target = new AliasVariableMapper();
        target.setBlockedPatterns(this.blockedPatterns);
        if (this.variables != null) {
            for (Map.Entry<String, ValueExpression> var : this.variables.entrySet()) {
                if (cacheValue) {
                    Object res = var.getValue().getValue((ELContext)ctx);
                    target.setVariable(var.getKey(), ctx.getExpressionFactory().createValueExpression(res, Object.class));
                    continue;
                }
                target.setVariable(var.getKey(), var.getValue());
            }
        }
        target.setId(ctx.generateUniqueId(this.tagId));
        this.apply(ctx, parent, target, this.nextHandler);
    }

    protected void apply(FaceletContext ctx, UIComponent parent, AliasVariableMapper alias, FaceletHandler nextHandler) throws IOException, FacesException, FaceletException, ELException {
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (configurationService.isBooleanPropertyTrue("nuxeo.jsf.removeAliasOptims")) {
            this.applyCompat(ctx, parent, alias, nextHandler);
            return;
        }
        boolean createComponent = this.isAnchored(ctx);
        this.applyAliasHandler(ctx, parent, alias, nextHandler, createComponent);
    }

    protected boolean isAnchored(FaceletContext ctx) {
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression ve = eFactory.createValueExpression((ELContext)ctx, String.format("#{%s}", ANCHOR_ENABLED_VARIABLE), Boolean.class);
        if (Boolean.TRUE.equals(ve.getValue((ELContext)ctx))) {
            return true;
        }
        if (this.anchor != null) {
            return this.anchor.getBoolean(ctx);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyAliasHandler(FaceletContext ctx, UIComponent parent, AliasVariableMapper alias, FaceletHandler nextHandler, boolean createComponent) throws IOException, FacesException, FaceletException, ELException {
        String id;
        UIComponent c;
        if (createComponent && (c = ComponentSupport.findChildByTagId((UIComponent)parent, (String)(id = ctx.generateUniqueId(this.getTagId())))) != null && c.getParent() != parent) {
            c.getParent().getChildren().remove(c);
        }
        id = alias.getId();
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapper vm = alias.getVariableMapperForBuild(orig);
        ctx.setVariableMapper(vm);
        FacesContext facesContext = ctx.getFacesContext();
        try {
            AliasVariableMapper.exposeAliasesToRequest(facesContext, alias);
            if (createComponent) {
                super.apply(ctx, parent);
            } else {
                nextHandler.apply(ctx, parent);
            }
        }
        finally {
            AliasVariableMapper.removeAliasesExposedToRequest(facesContext, id);
            ctx.setVariableMapper(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCompat(FaceletContext ctx, UIComponent parent, AliasVariableMapper alias, FaceletHandler nextHandler) throws IOException, FacesException, FaceletException, ELException {
        String id = alias.getId();
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapper vm = alias.getVariableMapperForBuild(orig);
        ctx.setVariableMapper(vm);
        Object c = ComponentSupport.findChildByTagId((UIComponent)parent, (String)id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            ComponentSupport.markForDeletion((UIComponent)c);
        } else {
            c = new UIAliasHolder();
            c.getAttributes().put("com.sun.faces.facelets.MARK_ID", id);
            if (this.id != null) {
                c.setId(this.id.getValue(ctx));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot((FaceletContext)ctx, (UIComponent)parent);
                if (root != null) {
                    String uid = root.createUniqueId();
                    c.setId(uid);
                }
            }
        }
        ((UIAliasHolder)((Object)c)).setAlias(alias);
        FacesContext facesContext = ctx.getFacesContext();
        try {
            AliasVariableMapper.exposeAliasesToRequest(facesContext, alias);
            nextHandler.apply(ctx, c);
        }
        finally {
            AliasVariableMapper.removeAliasesExposedToRequest(facesContext, id);
            ctx.setVariableMapper(orig);
        }
        if (componentFound) {
            ComponentSupport.finalizeForDeletion((UIComponent)c);
        }
        parent.getChildren().add(c);
    }
}

