/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.component.SelectItemFactory;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;

public abstract class DirectorySelectItemFactory
extends SelectItemFactory {
    private static final Log log = LogFactory.getLog(DirectorySelectItemFactory.class);

    protected abstract String getDirectoryName();

    protected Session getDirectorySession() {
        String dirName = this.getDirectoryName();
        return DirectorySelectItemFactory.getDirectorySession(dirName);
    }

    protected static Session getDirectorySession(String dirName) {
        Session directorySession = null;
        if (dirName != null) {
            try {
                DirectoryService service = DirectoryHelper.getDirectoryService();
                directorySession = service.open(dirName);
            }
            catch (DirectoryException e) {
                log.error((Object)String.format("Error when retrieving directory %s", dirName), (Throwable)e);
            }
        }
        return directorySession;
    }

    @Deprecated
    protected static void closeDirectorySession(Session directorySession) {
        if (directorySession != null) {
            try {
                directorySession.close();
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectItem createSelectItem(Object value) {
        SelectItem item;
        block24: {
            item = null;
            if (value instanceof SelectItem) {
                Object varValue = this.saveRequestMapVarValue();
                try {
                    this.putIteratorToRequestParam(value);
                    item = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                }
                finally {
                    this.restoreRequestMapVarValue(varValue);
                }
            }
            if (value instanceof String) {
                Object varValue = this.saveRequestMapVarValue();
                try (Session directorySession = this.getDirectorySession();){
                    String entryId = (String)value;
                    if (directorySession != null) {
                        try {
                            DocumentModel entry = directorySession.getEntry(entryId);
                            if (entry != null) {
                                this.putIteratorToRequestParam(entry);
                                item = this.createSelectItem();
                                this.removeIteratorFromRequestParam();
                            }
                            break block24;
                        }
                        catch (DirectoryException directoryException) {}
                        break block24;
                    }
                    log.error((Object)"No session provided for directory, returning empty selection");
                }
                finally {
                    this.restoreRequestMapVarValue(varValue);
                }
            }
        }
        return item;
    }
}

