/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.io;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ThumbnailJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "thumbnail";
    public static final String THUMBNAIL_URL_LABEL = "url";
    public static final String THUMB_THUMBNAIL = "thumb:thumbnail";
    public static final String DOWNLOAD_THUMBNAIL = "downloadThumbnail";

    public ThumbnailJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        block18: {
            ThumbnailAdapter thumbnailAdapter = (ThumbnailAdapter)document.getAdapter(ThumbnailAdapter.class);
            jg.writeFieldName(NAME);
            jg.writeStartObject();
            if (thumbnailAdapter != null) {
                try {
                    Blob thumbnail = null;
                    try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
                        thumbnail = thumbnailAdapter.getThumbnail(wrapper.getSession());
                    }
                    if (thumbnail != null) {
                        String url = DocumentModelFunctions.fileUrl(this.ctx.getBaseUrl().replaceAll("/$", ""), DOWNLOAD_THUMBNAIL, document, THUMB_THUMBNAIL, thumbnail.getFilename());
                        jg.writeStringField(THUMBNAIL_URL_LABEL, url);
                        break block18;
                    }
                    jg.writeNullField(THUMBNAIL_URL_LABEL);
                }
                catch (NuxeoException e) {
                    jg.writeNullField(THUMBNAIL_URL_LABEL);
                }
            } else {
                jg.writeNullField(THUMBNAIL_URL_LABEL);
            }
        }
        jg.writeEndObject();
    }
}

