/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.ValidatorConfig;
import org.nuxeo.ecm.platform.ui.web.binding.alias.UIAliasHolder;

public final class TagConfigFactory {
    private TagConfigFactory() {
    }

    public static TagConfig createTagConfig(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler) {
        return new TagConfigWrapper(tagConfig, tagConfigId, attributes, nextHandler);
    }

    public static ComponentConfig createComponentConfig(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String componentType, String rendererType) {
        return new ComponentConfigWrapper(tagConfig, tagConfigId, attributes, nextHandler, componentType, rendererType);
    }

    public static ConverterConfig createConverterConfig(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String converterId) {
        return new ConverterConfigWrapper(tagConfig, tagConfigId, attributes, nextHandler, converterId);
    }

    public static ValidatorConfig createValidatorConfig(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String validatorId) {
        return new ValidatorConfigWrapper(tagConfig, tagConfigId, attributes, nextHandler, validatorId);
    }

    public static ComponentConfig createAliasTagConfig(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler) {
        return new ComponentConfigWrapper(tagConfig, tagConfigId, attributes, nextHandler, UIAliasHolder.COMPONENT_TYPE, null);
    }

    public static ComponentConfig createAliasTagConfig(TagConfig tagConfig, String tagConfigId, String var, String value, String cache, String anchor, FaceletHandler nextHandler) {
        TagAttribute[] attrs = new TagAttribute[]{TagConfigFactory.createAttribute(tagConfig, "var", var), TagConfigFactory.createAttribute(tagConfig, "value", value), TagConfigFactory.createAttribute(tagConfig, "cache", cache), TagConfigFactory.createAttribute(tagConfig, "anchor", anchor)};
        TagAttributesImpl attributes = new TagAttributesImpl(attrs);
        return new ComponentConfigWrapper(tagConfig, tagConfigId, (TagAttributes)attributes, nextHandler, UIAliasHolder.COMPONENT_TYPE, null);
    }

    protected static TagAttribute createAttribute(TagConfig tagConfig, String name, String value) {
        return new TagAttributeImpl(tagConfig.getTag().getLocation(), "", name, name, value);
    }

    private static class ValidatorConfigWrapper
    extends TagConfigWrapper
    implements ValidatorConfig {
        protected final String validatorId;

        ValidatorConfigWrapper(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String validatorId) {
            super(tagConfig, tagConfigId, attributes, nextHandler);
            this.validatorId = validatorId;
        }

        public String getValidatorId() {
            return this.validatorId;
        }
    }

    private static class ConverterConfigWrapper
    extends TagConfigWrapper
    implements ConverterConfig {
        protected final String converterId;

        ConverterConfigWrapper(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String converterId) {
            super(tagConfig, tagConfigId, attributes, nextHandler);
            this.converterId = converterId;
        }

        public String getConverterId() {
            return this.converterId;
        }
    }

    private static class ComponentConfigWrapper
    extends TagConfigWrapper
    implements ComponentConfig {
        protected final String componentType;
        protected final String rendererType;

        ComponentConfigWrapper(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String componentType, String rendererType) {
            super(tagConfig, tagConfigId, attributes, nextHandler);
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }
    }

    private static class TagConfigWrapper
    implements TagConfig {
        protected final Tag tag;
        protected final String tagId;
        protected final FaceletHandler nextHandler;

        TagConfigWrapper(TagConfig tagConfig, String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler) {
            this.tag = new Tag(tagConfig.getTag(), attributes);
            this.tagId = tagConfigId == null ? tagConfig.getTagId() : tagConfig.getTagId() + tagConfigId;
            this.nextHandler = nextHandler;
        }

        public FaceletHandler getNextHandler() {
            return this.nextHandler;
        }

        public Tag getTag() {
            return this.tag;
        }

        public String getTagId() {
            return this.tagId;
        }
    }
}

