/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.invoker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.publisher.remoting.invoker.RemotePublicationInvoker;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.RemotePublisherMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.server.PublicationInvokationHandler;
import org.nuxeo.ecm.platform.publisher.remoting.server.TestInvokationHandler;

public class DefaultRemotePublicationInvoker
implements RemotePublicationInvoker {
    protected String baseURL;
    protected String userName;
    protected String password;
    protected RemotePublisherMarshaler marshaler;
    protected PublicationInvokationHandler testPublicationHandler;
    protected boolean useTestMode = false;

    @Override
    public void init(String baseURL, String userName, String password, RemotePublisherMarshaler marshaler) {
        this.baseURL = baseURL;
        this.userName = userName;
        this.password = password;
        this.marshaler = marshaler;
        if (baseURL.startsWith("test")) {
            this.useTestMode = true;
            this.testPublicationHandler = new TestInvokationHandler(marshaler);
        } else {
            this.useTestMode = false;
        }
    }

    @Override
    public Object invoke(String methodName, List<Object> params) {
        String marshaledData = this.marshaler.marshallParameters(params);
        String result = this.doInvoke(methodName, marshaledData);
        if (result == null) {
            return null;
        }
        return this.marshaler.unMarshallResult(result);
    }

    protected String doInvoke(String methodName, String marshaledData) {
        if (this.useTestMode) {
            return this.testPublicationHandler.invoke(methodName, marshaledData);
        }
        if (this.baseURL.startsWith("http")) {
            try {
                return this.doHttpCall(methodName, marshaledData);
            }
            catch (IOException e) {
                throw new NuxeoException("Error in http communication", (Throwable)e);
            }
        }
        throw new NuxeoException("Unhandled protocol for url " + this.baseURL);
    }

    protected String doHttpCall(String methodName, String marshaledData) throws IOException {
        int ch;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String BAHeaderContent = this.userName + ":" + this.password;
        BAHeaderContent = Base64.encodeBytes((byte[])BAHeaderContent.getBytes());
        String BAHeader = "basic " + BAHeaderContent;
        String targetUrl = this.baseURL + methodName;
        HttpPost httpPost = new HttpPost(targetUrl);
        StringEntity entity = new StringEntity(marshaledData, "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("content-type", "nuxeo/remotepub");
        httpPost.setHeader("authorization", BAHeader);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader(responseEntity.getContent(), "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        while ((ch = br.read()) > -1) {
            sb.append((char)ch);
        }
        br.close();
        String result = sb.toString();
        return result;
    }
}

