/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.AbstractDefaultXMLMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.ExtendedDocumentLocation;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.DocumentLocationMarshaler;

public class DefaultDocumentLocationMarshaler
extends AbstractDefaultXMLMarshaler
implements DocumentLocationMarshaler {
    protected String sourceServer;
    protected static QName rootTag = DocumentFactory.getInstance().createQName("documentLocation", "nxpub", "http://www.nuxeo.org/publisher");

    public String marshalDocumentLocation(DocumentLocation docLoc) {
        Element rootElem = DocumentFactory.getInstance().createElement(rootTag);
        rootElem.addNamespace("nxpub", "http://www.nuxeo.org/publisher");
        Document rootDoc = DocumentFactory.getInstance().createDocument(rootElem);
        rootElem.addAttribute("repository", docLoc.getServerName());
        rootElem.addAttribute("ref", docLoc.getDocRef().toString());
        if (this.sourceServer != null) {
            rootElem.addAttribute("originalServer", this.sourceServer);
        }
        String data = rootDoc.asXML();
        return this.cleanUpXml(data);
    }

    public DocumentLocation unMarshalDocumentLocation(String data) {
        DocumentLocationImpl docLoc;
        try {
            Document document = DocumentHelper.parseText((String)data);
            Element rootElem = document.getRootElement();
            String repoName = rootElem.attribute("repository").getValue();
            String refStr = rootElem.attribute("ref").getValue();
            Object ref = null;
            ref = refStr.startsWith("/") ? new PathRef(refStr) : new IdRef(refStr);
            docLoc = rootElem.attributeValue("originalServer") != null ? new ExtendedDocumentLocation(rootElem.attributeValue("originalServer"), repoName, (DocumentRef)ref) : new DocumentLocationImpl(repoName, (DocumentRef)ref);
        }
        catch (DocumentException e) {
            throw new NuxeoException("Unable to unmarshal Publication Node", (Throwable)e);
        }
        return docLoc;
    }

    public void setOriginatingServer(String serverName) {
        this.sourceServer = serverName;
    }
}

