/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.AbstractDefaultXMLMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.basic.BasicPublishedDocument;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.PublishedDocumentMarshaler;

public class DefaultPublishedDocumentMarshaler
extends AbstractDefaultXMLMarshaler
implements PublishedDocumentMarshaler {
    protected static QName rootTag = DocumentFactory.getInstance().createQName("publishedDocument", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName sourceRefTag = DocumentFactory.getInstance().createQName("sourceRef", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName repositoryNameTag = DocumentFactory.getInstance().createQName("repositoryName", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName serverNameTag = DocumentFactory.getInstance().createQName("serverName", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName versionLabelTag = DocumentFactory.getInstance().createQName("versionLabel", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName pathTag = DocumentFactory.getInstance().createQName("path", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName parentPathTag = DocumentFactory.getInstance().createQName("parentPath", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName isPendingTag = DocumentFactory.getInstance().createQName("isPending", "nxpub", "http://www.nuxeo.org/publisher");

    public String marshalPublishedDocument(PublishedDocument pubDoc) {
        if (pubDoc == null) {
            return "";
        }
        Element rootElem = DocumentFactory.getInstance().createElement(rootTag);
        rootElem.addNamespace("nxpub", "http://www.nuxeo.org/publisher");
        Document rootDoc = DocumentFactory.getInstance().createDocument(rootElem);
        Element sourceElem = rootElem.addElement(sourceRefTag);
        sourceElem.setText(pubDoc.getSourceDocumentRef().toString());
        Element repoElem = rootElem.addElement(repositoryNameTag);
        repoElem.setText(pubDoc.getSourceRepositoryName());
        Element srvElem = rootElem.addElement(serverNameTag);
        srvElem.setText(pubDoc.getSourceServer());
        Element versionElem = rootElem.addElement(versionLabelTag);
        versionElem.setText("" + pubDoc.getSourceVersionLabel());
        Element pathElem = rootElem.addElement(pathTag);
        pathElem.setText("" + pubDoc.getPath());
        Element parentPathElem = rootElem.addElement(parentPathTag);
        parentPathElem.setText("" + pubDoc.getParentPath());
        Element isPendingElem = rootElem.addElement(isPendingTag);
        isPendingElem.setText("" + pubDoc.isPending());
        String data = rootDoc.asXML();
        return this.cleanUpXml(data);
    }

    public PublishedDocument unMarshalPublishedDocument(String data) {
        BasicPublishedDocument pubDoc;
        try {
            Document document = DocumentHelper.parseText((String)data);
            Element rootElem = document.getRootElement();
            String strDocRef = rootElem.element(sourceRefTag).getTextTrim();
            Object docRef = strDocRef.startsWith("/") ? new PathRef(strDocRef) : new IdRef(strDocRef);
            String repo = rootElem.element(repositoryNameTag).getTextTrim();
            String server = rootElem.element(serverNameTag).getTextTrim();
            String version = rootElem.element(versionLabelTag).getTextTrim();
            String path = rootElem.element(pathTag).getTextTrim();
            String parentPath = rootElem.element(parentPathTag).getTextTrim();
            boolean isPending = Boolean.parseBoolean(rootElem.element(isPendingTag).getTextTrim());
            pubDoc = new BasicPublishedDocument((DocumentRef)docRef, repo, server, version, path, parentPath, isPending);
        }
        catch (DocumentException e) {
            throw new NuxeoException("Unable to unmarshal Published Document", (Throwable)e);
        }
        return pubDoc;
    }
}

