/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.directory;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.api.Framework;

@Deprecated
@Provider
@Consumes(value={"application/json", "application/json+nxentity"})
public class DirectoryEntryReader
implements MessageBodyReader<DirectoryEntry> {
    protected static final Log log = LogFactory.getLog(DirectoryEntryReader.class);
    @Context
    private JsonFactory factory;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DirectoryEntry.class.isAssignableFrom(type);
    }

    public DirectoryEntry readFrom(Class<DirectoryEntry> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty() && content.isEmpty()) {
            throw new WebException("No content in request body", Response.Status.BAD_REQUEST.getStatusCode());
        }
        try {
            return this.readRequest(content, httpHeaders);
        }
        catch (IOException | NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    private DirectoryEntry readRequest(String content, MultivaluedMap<String, String> httpHeaders) throws IOException {
        JsonParser jp = this.factory.createJsonParser(content);
        return DirectoryEntryReader.readJson(jp, httpHeaders);
    }

    public static DirectoryEntry readJson(JsonParser jp, MultivaluedMap<String, String> httpHeaders) throws IOException {
        JsonToken tok = jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            tok = jp.nextToken();
        }
        String directoryName = null;
        JsonNode propertiesNode = null;
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("directoryName".equals(key)) {
                directoryName = (String)jp.readValueAs(String.class);
            } else if ("properties".equals(key)) {
                propertiesNode = jp.readValueAsTree();
            } else if ("entity-type".equals(key)) {
                String entityType = (String)jp.readValueAs(String.class);
                if (!"directoryEntry".equals(entityType)) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            } else {
                log.debug((Object)("Unknown key: " + key));
                jp.skipChildren();
            }
            tok = jp.nextToken();
        }
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        Directory directory = ds.getDirectory(directoryName);
        if (directory == null) {
            throw new WebResourceNotFoundException("Directory " + directoryName + " does not exists");
        }
        return DirectoryEntryReader.getDirectoryEntryFromNode(propertiesNode, directory);
    }

    private static DirectoryEntry getDirectoryEntryFromNode(JsonNode propertiesNode, Directory directory) throws DirectoryException, IOException {
        String schema = directory.getSchema();
        String id = propertiesNode.get(directory.getIdField()).getTextValue();
        try (Session session = directory.getSession();){
            DocumentModel entry = session.getEntry(id);
            if (entry == null) {
                entry = BaseSession.createEntryModel(null, (String)schema, (String)id, new HashMap());
            }
            Properties props = new Properties();
            Iterator fields = propertiesNode.getFields();
            while (fields.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)fields.next();
                props.put((Object)(schema + ":" + (String)fieldEntry.getKey()), (Object)((JsonNode)fieldEntry.getValue()).getTextValue());
            }
            DocumentHelper.setProperties(null, (DocumentModel)entry, (Properties)props);
            DirectoryEntry directoryEntry = new DirectoryEntry(directory.getName(), entry);
            return directoryEntry;
        }
    }
}

