/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityReply;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;

public class PollActivityStreamFilter
implements ActivityStreamFilter {
    public static final String ID = "PollActivityStreamFilter";
    public static final String QUERY_TYPE_PARAMETER = "queryTypeParameter";
    public static final String SURVEY_ID_PARAMETER = "pollId";
    public static final String ACTOR_PARAMETER = "actor";

    public String getId() {
        return ID;
    }

    public boolean isInterestedIn(Activity activity) {
        return "answer poll".equals(activity.getVerb());
    }

    public void handleNewActivity(ActivityStreamService activityStreamService, Activity activity) {
    }

    @Deprecated
    public void handleRemovedActivities(ActivityStreamService activityStreamService, Collection<Serializable> activityIds) {
    }

    public void handleRemovedActivities(ActivityStreamService activityStreamService, ActivitiesList activities) {
    }

    public void handleRemovedActivityReply(ActivityStreamService activityStreamService, Activity activity, ActivityReply activityReply) {
    }

    public ActivitiesList query(ActivityStreamService activityStreamService, Map<String, Serializable> parameters, long offset, long limit) {
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        QueryType queryType = (QueryType)((Object)parameters.get(QUERY_TYPE_PARAMETER));
        if (queryType == null) {
            return new ActivitiesListImpl();
        }
        Query query = null;
        String pollId = (String)((Object)parameters.get(SURVEY_ID_PARAMETER));
        String actor = (String)((Object)parameters.get(ACTOR_PARAMETER));
        switch (queryType) {
            case ALL_ANSWERS_FOR_SURVEY: {
                query = em.createQuery("select activity from Activity activity where activity.target = :pollId");
                query.setParameter(SURVEY_ID_PARAMETER, (Object)pollId);
                break;
            }
            case ACTOR_ANSWERS_FOR_SURVEY: {
                query = em.createQuery("select activity from Activity activity where activity.target = :pollId and activity.actor = :actor");
                query.setParameter(SURVEY_ID_PARAMETER, (Object)pollId);
                query.setParameter(ACTOR_PARAMETER, (Object)actor);
            }
        }
        if (query == null) {
            return new ActivitiesListImpl();
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        return new ActivitiesListImpl((Collection)query.getResultList());
    }

    public static enum QueryType {
        ALL_ANSWERS_FOR_SURVEY,
        ACTOR_ANSWERS_FOR_SURVEY;

    }
}

