/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.poll.Poll;

public class PollAdapter
implements Poll {
    protected final DocumentModel pollDoc;

    public PollAdapter(DocumentModel poll) {
        this.pollDoc = poll;
    }

    @Override
    public String getId() {
        return this.pollDoc.getId();
    }

    @Override
    public String getQuestion() {
        return (String)((Object)this.getPropertyValue("dc:title"));
    }

    @Override
    public String[] getAnswers() {
        return (String[])this.getPropertyValue("poll:answers");
    }

    @Override
    public Date getStartDate() {
        Calendar cal = (Calendar)this.getPropertyValue("poll:start_date");
        return cal == null ? null : cal.getTime();
    }

    @Override
    public Date getEndDate() {
        Calendar cal = (Calendar)this.getPropertyValue("dc:expired");
        return cal == null ? null : cal.getTime();
    }

    protected Serializable getPropertyValue(String xpath) {
        try {
            return this.pollDoc.getPropertyValue(xpath);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isInProject() {
        return this.safeLifeCycleStateCheck("project");
    }

    @Override
    public boolean isOpen() {
        return this.safeLifeCycleStateCheck("open");
    }

    @Override
    public boolean isClosed() {
        return this.safeLifeCycleStateCheck("closed");
    }

    protected boolean safeLifeCycleStateCheck(String lifeCycleState) {
        try {
            return lifeCycleState.equals(this.pollDoc.getCurrentLifeCycleState());
        }
        catch (ClientException e) {
            return false;
        }
    }

    @Override
    public DocumentModel getPollDocument() {
        return this.pollDoc;
    }
}

