/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll;

import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.poll.Poll;
import org.nuxeo.ecm.poll.PollResult;

public class PollHelper {
    private PollHelper() {
    }

    public static Poll toPoll(DocumentModel pollDocument) {
        return (Poll)pollDocument.getAdapter(Poll.class);
    }

    public static JSONObject toJSON(Poll poll, boolean answered) {
        JSONObject object = new JSONObject();
        object.put((Object)"pollId", (Object)poll.getId());
        object.put((Object)"answered", (Object)answered);
        object.put((Object)"question", (Object)poll.getQuestion());
        object.put((Object)"answers", (Object)poll.getAnswers());
        return object;
    }

    public static JSONObject toJSON(Poll poll) {
        return PollHelper.toJSON(poll, false);
    }

    public static JSONObject toJSON(PollResult pollResult) {
        JSONObject object = new JSONObject();
        object.put((Object)"resultsCount", (Object)pollResult.getResultsCount());
        JSONArray resultsByAnswer = new JSONArray();
        for (Map.Entry<String, Long> entry : pollResult.getResultsByAnswer().entrySet()) {
            JSONObject answer = new JSONObject();
            answer.put((Object)"answer", (Object)entry.getKey());
            answer.put((Object)"result", (Object)entry.getValue());
            resultsByAnswer.add((Object)answer);
        }
        object.put((Object)"resultsByAnswer", (Object)resultsByAnswer);
        return object;
    }

    public static JSONObject toJSON(Poll poll, PollResult pollResult, boolean answered) {
        JSONObject object = PollHelper.toJSON(poll, answered);
        object.put((Object)"result", (Object)PollHelper.toJSON(pollResult));
        return object;
    }

    public static JSONObject toJSON(Poll poll, PollResult pollResult) {
        return PollHelper.toJSON(poll, pollResult, false);
    }
}

