/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.poll.Poll;
import org.nuxeo.ecm.poll.PollActivityStreamFilter;
import org.nuxeo.ecm.poll.PollHelper;
import org.nuxeo.ecm.poll.PollResult;
import org.nuxeo.ecm.poll.PollService;
import org.nuxeo.runtime.api.Framework;

public class PollServiceImpl
implements PollService {
    public static final String SURVEYS_CONTAINER_NAME = "pollsContainer";
    protected ActivityStreamService activityStreamService;

    @Override
    public DocumentModel getPollsContainer(DocumentModel doc) {
        try {
            Path pollsContainerPath = doc.getPath().append(SURVEYS_CONTAINER_NAME);
            PathRef pollsContainerRef = new PathRef(pollsContainerPath.toString());
            CoreSession session = doc.getCoreSession();
            if (session.exists((DocumentRef)pollsContainerRef)) {
                return session.getDocument((DocumentRef)pollsContainerRef);
            }
            return this.createPollsContainer(session, doc);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected DocumentModel createPollsContainer(CoreSession session, DocumentModel doc) {
        try {
            DocumentModel pollsContainer = session.createDocumentModel(doc.getPathAsString(), SURVEYS_CONTAINER_NAME, "HiddenFolder");
            pollsContainer.setPropertyValue("dc:title", (Serializable)((Object)"Polls"));
            pollsContainer = session.createDocument(pollsContainer);
            session.save();
            return pollsContainer;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<Poll> getOpenPolls(CoreSession session) {
        try {
            String query = "SELECT * FROM Document WHERE ecm:primaryType = '%s' AND ecm:currentLifeCycleState = '%s' ORDER BY %s";
            DocumentModelList docs = session.query(String.format(query, "Poll", "open", "poll:start_date"));
            ArrayList<Poll> polls = new ArrayList<Poll>();
            for (DocumentModel doc : docs) {
                polls.add(PollHelper.toPoll(doc));
            }
            return polls;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<Poll> getUnansweredOpenPolls(CoreSession session) {
        List<Poll> polls = this.getOpenPolls(session);
        Iterator<Poll> it = polls.iterator();
        while (it.hasNext()) {
            Poll poll = it.next();
            if (!this.hasUserAnswered(session.getPrincipal().getName(), poll)) continue;
            it.remove();
        }
        return polls;
    }

    @Override
    public boolean hasUserAnswered(String username, Poll poll) {
        ActivityStreamService activityStreamService = this.getActivityStreamService();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)PollActivityStreamFilter.QueryType.ACTOR_ANSWERS_FOR_SURVEY);
        parameters.put("pollId", poll.getId());
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)username));
        ActivitiesList activities = activityStreamService.query("PollActivityStreamFilter", parameters);
        return !activities.isEmpty();
    }

    @Override
    public void answer(String username, Poll poll, int answerIndex) {
        Activity activity = new ActivityBuilder().verb("answer poll").actor(ActivityHelper.createUserActivityObject((String)username)).target(poll.getId()).object(this.getAnswer(poll, answerIndex)).build();
        this.getActivityStreamService().addActivity(activity);
    }

    private String getAnswer(Poll poll, int answerIndex) {
        String[] answers = poll.getAnswers();
        return answers.length > answerIndex ? answers[answerIndex] : null;
    }

    @Override
    public PollResult getResultFor(Poll poll) {
        String[] answers;
        ActivityStreamService activityStreamService = this.getActivityStreamService();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)PollActivityStreamFilter.QueryType.ALL_ANSWERS_FOR_SURVEY);
        parameters.put("pollId", poll.getId());
        ActivitiesList activities = activityStreamService.query("PollActivityStreamFilter", parameters);
        LinkedHashMap<String, Long> resultsByAnswer = new LinkedHashMap<String, Long>();
        for (String answer : answers = poll.getAnswers()) {
            resultsByAnswer.put(answer, 0L);
        }
        for (Activity activity : activities) {
            Long result = (Long)resultsByAnswer.get(activity.getObject());
            if (result == null) {
                result = 0L;
            }
            result = result + 1L;
            resultsByAnswer.put(activity.getObject(), result);
        }
        return new PollResult(poll.getId(), resultsByAnswer);
    }

    @Override
    public Poll openPoll(Poll poll) {
        try {
            DocumentModel pollDocument = poll.getPollDocument();
            CoreSession session = pollDocument.getCoreSession();
            pollDocument.followTransition("open");
            pollDocument.setPropertyValue("poll:start_date", (Serializable)new Date());
            pollDocument = session.saveDocument(pollDocument);
            session.save();
            return PollHelper.toPoll(pollDocument);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public Poll closePoll(Poll poll) {
        try {
            DocumentModel pollDocument = poll.getPollDocument();
            CoreSession session = pollDocument.getCoreSession();
            pollDocument.followTransition("close");
            pollDocument.setPropertyValue("dc:expired", (Serializable)new Date());
            pollDocument = session.saveDocument(pollDocument);
            session.save();
            return PollHelper.toPoll(pollDocument);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public Poll updatePollStatus(Poll poll, Date date) {
        Date startDate = poll.getStartDate();
        Date endDate = poll.getEndDate();
        if (poll.isInProject()) {
            if (startDate != null && date.after(startDate)) {
                poll = this.openPoll(poll);
            }
        } else if (poll.isOpen() && endDate != null && date.after(endDate)) {
            poll = this.closePoll(poll);
        }
        return poll;
    }

    protected ActivityStreamService getActivityStreamService() throws ClientRuntimeException {
        if (this.activityStreamService == null) {
            try {
                this.activityStreamService = (ActivityStreamService)Framework.getService(ActivityStreamService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to ActivityStreamService. " + e.getMessage();
                throw new ClientRuntimeException(errMsg, (Throwable)e);
            }
            if (this.activityStreamService == null) {
                throw new ClientRuntimeException("ActivityStreamService service not bound");
            }
        }
        return this.activityStreamService;
    }
}

