/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll.listeners;

import java.util.Date;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.poll.Poll;
import org.nuxeo.ecm.poll.PollHelper;
import org.nuxeo.ecm.poll.PollService;
import org.nuxeo.runtime.api.Framework;

public class UpdateAllPollsStatusListener
implements EventListener {
    public static final String UPDATE_SURVEYS_STATUS_EVENT = "updatePollsStatus";

    public void handleEvent(Event event) throws ClientException {
        if (!UPDATE_SURVEYS_STATUS_EVENT.equals(event.getName())) {
            return;
        }
        try {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
            String repositoryName = repositoryManager.getDefaultRepositoryName();
            UpdatePollsStatus updatePollsStatus = new UpdatePollsStatus(repositoryName);
            updatePollsStatus.runUnrestricted();
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public static class UpdatePollsStatus
    extends UnrestrictedSessionRunner {
        public UpdatePollsStatus(String repositoryName) {
            super(repositoryName);
        }

        public void run() throws ClientException {
            String query = "SELECT * FROM Poll WHERE ecm:currentLifeCycleState <> '%s' AND ecm:currentLifeCycleState <> '%s'";
            DocumentModelList polls = this.session.query(String.format(query, "closed", "deleted"));
            PollService pollService = this.getPollService();
            Date now = new Date();
            for (DocumentModel poll : polls) {
                this.updateStatus(pollService, PollHelper.toPoll(poll), now);
            }
            this.session.save();
        }

        protected void updateStatus(PollService pollService, Poll poll, Date now) throws ClientException {
            pollService.updatePollStatus(poll, now);
        }

        protected PollService getPollService() throws ClientException {
            try {
                return (PollService)Framework.getService(PollService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
    }
}

