/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll.listeners;

import java.util.Date;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.poll.PollHelper;
import org.nuxeo.ecm.poll.PollService;
import org.nuxeo.runtime.api.Framework;

public class UpdatePollStatusListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        if (events.containsEventName("documentCreated") || events.containsEventName("documentModified")) {
            for (Event event : events) {
                if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName())) continue;
                this.handleEvent(event);
            }
        }
    }

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docEventContext;
        DocumentModel doc;
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext && "Poll".equals((doc = (docEventContext = (DocumentEventContext)eventContext).getSourceDocument()).getType())) {
            this.getPollService().updatePollStatus(PollHelper.toPoll(doc), new Date());
        }
    }

    protected PollService getPollService() throws ClientException {
        try {
            return (PollService)Framework.getService(PollService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }
}

