/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.poll.Poll;
import org.nuxeo.ecm.poll.PollHelper;
import org.nuxeo.ecm.poll.PollResult;
import org.nuxeo.ecm.poll.PollService;

@Operation(id="Services.AnswerPoll", category="Services", label="Answer a poll", description="Answer a poll.The pollId and answerIndex are required parameters.")
public class AnswerPoll {
    public static final String ID = "Services.AnswerPoll";
    @Context
    protected CoreSession session;
    @Context
    protected PollService pollService;
    @Param(name="pollId")
    protected String pollId;
    @Param(name="answerIndex")
    protected Integer answerIndex;

    @OperationMethod
    public Blob run() throws Exception {
        DocumentModel pollDocument = this.session.getDocument((DocumentRef)new IdRef(this.pollId));
        Poll poll = PollHelper.toPoll(pollDocument);
        PollResult pollResult = this.pollService.getResultFor(poll);
        this.pollService.answer(this.session.getPrincipal().getName(), poll, this.answerIndex);
        String[] answers = poll.getAnswers();
        String answer = answers[this.answerIndex];
        Long result = pollResult.getResultsByAnswer().get(answer);
        if (result == null) {
            result = 0L;
        }
        pollResult.getResultsByAnswer().put(answer, result + 1L);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(PollHelper.toJSON(poll, pollResult, true).toString().getBytes("UTF-8")), "application/json");
    }
}

