/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.poll.Poll;
import org.nuxeo.ecm.poll.PollHelper;
import org.nuxeo.ecm.poll.PollResult;
import org.nuxeo.ecm.poll.PollService;

@Operation(id="Services.GetOpenPolls", category="Services", label="Get open polls", description="Get open polls.Default is to get all open polls.The 'onlyUnansweredPolls' parameter can be used to retrieve only the unanswered polls.")
public class GetOpenPolls {
    public static final String ID = "Services.GetOpenPolls";
    @Context
    protected CoreSession session;
    @Context
    protected PollService pollService;
    @Param(name="onlyUnansweredPolls", required=false)
    protected Boolean onlyUnansweredPolls = false;

    @OperationMethod
    public Blob run() throws ClientException, IOException {
        JSONArray array = new JSONArray();
        if (this.onlyUnansweredPolls.booleanValue()) {
            List<Poll> availablePolls = this.pollService.getUnansweredOpenPolls(this.session);
            for (Poll poll : availablePolls) {
                this.writeUnansweredPoll(array, poll);
            }
        } else {
            List<Poll> availablePolls = this.pollService.getOpenPolls(this.session);
            for (Poll poll : availablePolls) {
                this.writePoll(array, poll);
            }
        }
        JSONObject object = new JSONObject();
        object.put((Object)"polls", (Object)array);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(object.toString().getBytes("UTF-8")), "application/json");
    }

    protected void writePoll(JSONArray array, Poll poll) throws ClientException, IOException {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.session.getPrincipal();
        if (this.pollService.hasUserAnswered(principal.getName(), poll)) {
            this.writeAnsweredPoll(array, poll);
        } else {
            this.writeUnansweredPoll(array, poll);
        }
    }

    protected void writeAnsweredPoll(JSONArray array, Poll poll) throws ClientException, IOException {
        PollResult pollResult = this.pollService.getResultFor(poll);
        array.add((Object)PollHelper.toJSON(poll, pollResult, true));
    }

    protected void writeUnansweredPoll(JSONArray array, Poll poll) throws IOException, ClientException {
        array.add((Object)PollHelper.toJSON(poll));
    }
}

