/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.poll.Poll;
import org.nuxeo.ecm.poll.PollHelper;
import org.nuxeo.ecm.poll.PollResult;
import org.nuxeo.ecm.poll.PollService;

@Operation(id="Services.GetPoll", category="Services", label="Get a poll", description="Get a poll based on its id.Returns also the poll result if the parameter 'withResult' is 'true'.")
public class GetPoll {
    public static final String ID = "Services.GetPoll";
    @Context
    protected CoreSession session;
    @Context
    protected PollService pollService;
    @Param(name="pollId")
    protected String pollId;
    @Param(name="withResult", required=false)
    protected Boolean withResult = false;

    @OperationMethod
    public Blob run() throws Exception {
        JSONObject json;
        DocumentModel pollDocument = this.session.getDocument((DocumentRef)new IdRef(this.pollId));
        Poll poll = PollHelper.toPoll(pollDocument);
        boolean alreadyAnswered = this.pollService.hasUserAnswered(this.session.getPrincipal().getName(), poll);
        if (this.withResult.booleanValue()) {
            PollResult pollResult = this.pollService.getResultFor(poll);
            json = PollHelper.toJSON(poll, pollResult, alreadyAnswered);
        } else {
            json = PollHelper.toJSON(poll, alreadyAnswered);
        }
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(json.toString().getBytes("UTF-8")), "application/json");
    }
}

