/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.web;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataServlet
extends HttpServlet {
    protected static final Log log = LogFactory.getLog(MetadataServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)request);
        baseURL = baseURL + (baseURL.endsWith("/") ? "" : "/") + "nxstartup.faces";
        EntityDescriptor descriptor = SAMLConfiguration.getEntityDescriptor(baseURL);
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)descriptor);
            if (marshaller == null) {
                log.error((Object)("Unable to marshall message, no marshaller registered for message object: " + descriptor.getElementQName()));
            }
            Element dom = marshaller.marshall((XMLObject)descriptor);
            XMLHelper.writeNode((Node)dom, (Writer)response.getWriter());
        }
        catch (MarshallingException e) {
            log.error((Object)"Unable to write metadata.");
        }
    }
}

