/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import java.math.BigInteger;
import org.opensaml.xml.schema.impl.XSBase64BinaryImpl;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.signature.CryptoBinary;
import org.opensaml.xml.util.DatatypeHelper;

public class CryptoBinaryImpl
extends XSBase64BinaryImpl
implements CryptoBinary {
    private BigInteger bigIntValue;

    protected CryptoBinaryImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public BigInteger getValueBigInt() {
        if (this.bigIntValue == null && !DatatypeHelper.isEmpty(this.getValue())) {
            this.bigIntValue = KeyInfoHelper.decodeBigIntegerFromCryptoBinary(this.getValue());
        }
        return this.bigIntValue;
    }

    @Override
    public void setValueBigInt(BigInteger bigInt) {
        if (bigInt == null) {
            this.setValue(null);
        } else {
            this.setValue(KeyInfoHelper.encodeCryptoBinaryFromBigInteger(bigInt));
        }
        this.bigIntValue = bigInt;
    }

    @Override
    public void setValue(String newValue) {
        if (!(this.bigIntValue == null || DatatypeHelper.safeEquals(this.getValue(), newValue) && newValue != null)) {
            this.bigIntValue = null;
        }
        super.setValue(newValue);
    }
}

