/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.auth.saml.AbstractSAMLProfile;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.binding.HTTPPostBinding;
import org.nuxeo.ecm.platform.auth.saml.binding.HTTPRedirectBinding;
import org.nuxeo.ecm.platform.auth.saml.binding.SAMLBinding;
import org.nuxeo.ecm.platform.auth.saml.key.KeyManager;
import org.nuxeo.ecm.platform.auth.saml.slo.SLOProfile;
import org.nuxeo.ecm.platform.auth.saml.slo.SLOProfileImpl;
import org.nuxeo.ecm.platform.auth.saml.sso.WebSSOProfile;
import org.nuxeo.ecm.platform.auth.saml.sso.WebSSOProfileImpl;
import org.nuxeo.ecm.platform.auth.saml.user.AbstractUserResolver;
import org.nuxeo.ecm.platform.auth.saml.user.EmailBasedUserResolver;
import org.nuxeo.ecm.platform.auth.saml.user.UserMapperBasedResolver;
import org.nuxeo.ecm.platform.auth.saml.user.UserResolver;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.service.UserMapperService;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.security.MetadataCredentialResolver;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.encryption.ChainingEncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.InlineEncryptedKeyResolver;
import org.opensaml.xml.encryption.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;

public class SAMLAuthenticationProvider
implements NuxeoAuthenticationPlugin,
LoginProviderLinkComputer,
NuxeoAuthenticationPluginLogoutExtension {
    private static final Log log = LogFactory.getLog(SAMLAuthenticationProvider.class);
    private static final String ERROR_PAGE = "saml/error.jsp";
    private static final String ERROR_AUTH = "error.saml.auth";
    private static final String ERROR_USER = "error.saml.userMapping";
    private static final Class<? extends UserResolver> DEFAULT_USER_RESOLVER_CLASS = EmailBasedUserResolver.class;
    private static final Class<? extends UserResolver> USERMAPPER_USER_RESOLVER_CLASS = UserMapperBasedResolver.class;
    static final String SAML_SESSION_KEY = "SAML_SESSION";
    static List<SAMLBinding> bindings = new ArrayList<SAMLBinding>();
    private static ChainingEncryptedKeyResolver encryptedKeyResolver;
    private Map<String, AbstractSAMLProfile> profiles = new HashMap<String, AbstractSAMLProfile>();
    private UserResolver userResolver;
    private KeyManager keyManager;
    private SignatureTrustEngine trustEngine;
    private Decrypter decrypter;
    private MetadataProvider metadataProvider;

    public void initPlugin(Map<String, String> parameters) {
        String userResolverClassname = parameters.get("userResolverClass");
        Class<UserResolver> userResolverClass = null;
        if (StringUtils.isBlank((String)userResolverClassname)) {
            UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
            userResolverClass = ums != null ? USERMAPPER_USER_RESOLVER_CLASS : DEFAULT_USER_RESOLVER_CLASS;
        } else {
            try {
                userResolverClass = Class.forName(userResolverClassname).asSubclass(AbstractUserResolver.class);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Failed get user resolver class " + userResolverClassname));
            }
        }
        try {
            this.userResolver = userResolverClass.newInstance();
            this.userResolver.init(parameters);
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Object)("Failed to initialize user resolver " + userResolverClassname));
        }
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            log.error((Object)"Failed to bootstrap OpenSAML", (Throwable)e);
        }
        try {
            this.initializeMetadataProvider(parameters);
            MetadataCredentialResolver metadataCredentialResolver = new MetadataCredentialResolver(this.metadataProvider);
            this.trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)metadataCredentialResolver, Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver());
            Credential encryptionCredential = this.getKeyManager().getEncryptionCredential();
            if (encryptionCredential != null) {
                StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver(encryptionCredential);
                this.decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)encryptedKeyResolver);
                this.decrypter.setRootInNewDocument(true);
            }
            block8: for (RoleDescriptor roleDescriptor : this.getIdPDescriptor().getRoleDescriptors()) {
                if (!roleDescriptor.getElementQName().equals(IDPSSODescriptor.DEFAULT_ELEMENT_NAME) || !roleDescriptor.isSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol")) continue;
                IDPSSODescriptor idpSSO = (IDPSSODescriptor)roleDescriptor;
                for (SingleSignOnService sso : idpSSO.getSingleSignOnServices()) {
                    if (!sso.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) continue;
                    this.addProfile(new WebSSOProfileImpl(sso));
                    break;
                }
                for (SingleLogoutService slo : idpSSO.getSingleLogoutServices()) {
                    if (!slo.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) continue;
                    this.addProfile(new SLOProfileImpl(slo));
                    continue block8;
                }
            }
        }
        catch (MetadataProviderException e) {
            log.warn((Object)("Failed to register IdP: " + e.getMessage()));
        }
        if (StringUtils.isNotBlank((String)parameters.get("name"))) {
            LoginScreenHelper.registerLoginProvider((String)parameters.get("name"), (String)parameters.get("icon"), null, (String)parameters.get("label"), (String)parameters.get("description"), (LoginProviderLinkComputer)this);
        }
    }

    private void addProfile(AbstractSAMLProfile profile) {
        profile.setTrustEngine(this.trustEngine);
        profile.setDecrypter(this.decrypter);
        this.profiles.put(profile.getProfileIdentifier(), profile);
    }

    private void initializeMetadataProvider(Map<String, String> parameters) throws MetadataProviderException {
        String metadataUrl = parameters.get("metadata");
        if (metadataUrl == null) {
            throw new MetadataProviderException("No metadata URI set for provider " + (parameters.containsKey("name") ? parameters.get("name") : ""));
        }
        int requestTimeout = parameters.containsKey("timeout") ? Integer.parseInt(parameters.get("timeout")) : 5;
        Object metadataProvider = metadataUrl.startsWith("http:") || metadataUrl.startsWith("https:") ? new HTTPMetadataProvider(metadataUrl, requestTimeout * 1000) : new FilesystemMetadataProvider(new File(metadataUrl));
        metadataProvider.setParserPool((ParserPool)new BasicParserPool());
        metadataProvider.initialize();
        this.metadataProvider = metadataProvider;
    }

    private EntityDescriptor getIdPDescriptor() throws MetadataProviderException {
        return (EntityDescriptor)this.metadataProvider.getMetadata();
    }

    protected String getSSOUrl(HttpServletRequest request, HttpServletResponse response) {
        WebSSOProfile sso = (WebSSOProfile)((Object)this.profiles.get("urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser"));
        if (sso == null) {
            return null;
        }
        BasicSAMLMessageContext context = new BasicSAMLMessageContext();
        this.populateLocalContext((SAMLMessageContext)context);
        String requestedUrl = this.getRequestedUrl(request);
        if (requestedUrl != null) {
            context.setRelayState(requestedUrl);
        }
        HTTPRedirectBinding binding = (HTTPRedirectBinding)this.getBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        String loginURL = sso.getEndpoint().getLocation();
        try {
            AuthnRequest authnRequest = sso.buildAuthRequest(request, new String[0]);
            authnRequest.setDestination(sso.getEndpoint().getLocation());
            context.setOutboundSAMLMessage((SAMLObject)authnRequest);
            loginURL = binding.buildRedirectURL((SAMLMessageContext)context, sso.getEndpoint().getLocation());
        }
        catch (SAMLException e) {
            log.error((Object)"Failed to build redirect URL", (Throwable)e);
        }
        return loginURL;
    }

    private String getRequestedUrl(HttpServletRequest request) {
        HttpSession session;
        String requestedUrl = (String)request.getAttribute("requestedUrl");
        if (requestedUrl == null && (session = request.getSession(false)) != null) {
            requestedUrl = (String)session.getAttribute("Nuxeo5_Start_Page");
        }
        return requestedUrl;
    }

    public String computeUrl(HttpServletRequest request, String requestedUrl) {
        return this.getSSOUrl(request, null);
    }

    public Boolean handleLoginPrompt(HttpServletRequest request, HttpServletResponse response, String baseURL) {
        String loginError = (String)request.getAttribute("org.nuxeo.ecm.login.error");
        if (loginError != null) {
            try {
                request.getRequestDispatcher(ERROR_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            catch (IOException | ServletException e) {
                log.error((Object)"Failed to redirect to error page", e);
                return false;
            }
        }
        String loginURL = this.getSSOUrl(request, response);
        try {
            response.sendRedirect(loginURL);
        }
        catch (IOException e) {
            String errorMessage = String.format("Unable to send redirect on %s", loginURL);
            log.error((Object)errorMessage, (Throwable)e);
            return false;
        }
        return true;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session;
        SAMLCredential credential;
        HttpServletRequestAdapter inTransport = new HttpServletRequestAdapter(request);
        SAMLBinding binding = this.getBinding((InTransport)inTransport);
        if (binding == null) {
            return null;
        }
        HttpServletResponseAdapter outTransport = new HttpServletResponseAdapter(response, request.isSecure());
        BasicSAMLMessageContext context = new BasicSAMLMessageContext();
        context.setInboundMessageTransport((InTransport)inTransport);
        context.setOutboundMessageTransport((OutTransport)outTransport);
        this.populateLocalContext((SAMLMessageContext)context);
        try {
            binding.decode((MessageContext)context);
        }
        catch (MessageDecodingException | SecurityException e) {
            log.error((Object)"Error during SAML decoding", e);
            return null;
        }
        try {
            if (context.getPeerEntityId() == null) {
                context.setPeerEntityId(this.getIdPDescriptor().getEntityID());
            }
            if (context.getPeerEntityMetadata() == null) {
                context.setPeerEntityMetadata(this.getIdPDescriptor());
            }
            if (context.getPeerEntityRole() == null) {
                context.setPeerEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            }
        }
        catch (MetadataProviderException e) {
            // empty catch block
        }
        AbstractSAMLProfile processor = this.getProcessor((SAMLMessageContext)context);
        if (processor == null) {
            log.warn((Object)("Unsupported profile encountered in the context " + context.getCommunicationProfileId()));
            return null;
        }
        context.setCommunicationProfileId(processor.getProfileIdentifier());
        SAMLObject message = context.getInboundSAMLMessage();
        if (processor instanceof SLOProfile) {
            SLOProfile slo = (SLOProfile)((Object)processor);
            try {
                if (message instanceof LogoutResponse) {
                    slo.processLogoutResponse((SAMLMessageContext)context);
                } else if (message instanceof LogoutRequest) {
                    SAMLCredential credential2 = this.getSamlCredential(request);
                    slo.processLogoutRequest((SAMLMessageContext)context, credential2);
                }
            }
            catch (SAMLException e) {
                log.debug((Object)"Error processing SAML message", (Throwable)e);
            }
            return null;
        }
        try {
            credential = ((WebSSOProfile)((Object)processor)).processAuthenticationResponse((SAMLMessageContext)context);
        }
        catch (SAMLException e) {
            log.error((Object)"Error processing SAML message", (Throwable)e);
            this.sendError(request, ERROR_AUTH);
            return null;
        }
        String userId = this.userResolver.findOrCreateNuxeoUser(credential);
        if (userId == null) {
            log.warn((Object)("Failed to resolve user with NameID \"" + credential.getNameID().getValue() + "\"."));
            this.sendError(request, ERROR_USER);
            return null;
        }
        if (credential.getSessionIndexes() != null && !credential.getSessionIndexes().isEmpty()) {
            String nameValue = credential.getNameID().getValue();
            String nameFormat = credential.getNameID().getFormat();
            String sessionId = credential.getSessionIndexes().get(0);
            this.addCookie(response, SAML_SESSION_KEY, sessionId + "|" + nameValue + "|" + nameFormat);
        }
        if ((session = request.getSession(!response.isCommitted())) != null && StringUtils.isNotEmpty((String)credential.getRelayState())) {
            session.setAttribute("Nuxeo5_Start_Page", (Object)credential.getRelayState());
        }
        return new UserIdentificationInfo(userId, userId);
    }

    protected AbstractSAMLProfile getProcessor(SAMLMessageContext context) {
        SAMLObject message = context.getInboundSAMLMessage();
        String profileId = message instanceof LogoutResponse || message instanceof LogoutRequest ? "urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout" : "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
        return this.profiles.get(profileId);
    }

    protected SAMLBinding getBinding(String bindingURI) {
        for (SAMLBinding binding : bindings) {
            if (!binding.getBindingURI().equals(bindingURI)) continue;
            return binding;
        }
        return null;
    }

    protected SAMLBinding getBinding(InTransport transport) {
        for (SAMLBinding binding : bindings) {
            if (!binding.supports(transport)) continue;
            return binding;
        }
        return null;
    }

    private void populateLocalContext(SAMLMessageContext context) {
        context.setLocalEntityId(SAMLConfiguration.getEntityId());
        context.setLocalEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        context.setMetadataProvider(this.metadataProvider);
        this.keyManager = (KeyManager)Framework.getLocalService(KeyManager.class);
        if (this.getKeyManager().getSigningCredential() != null) {
            context.setOutboundSAMLMessageSigningCredential(this.getKeyManager().getSigningCredential());
        }
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return true;
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    protected String getSLOUrl(HttpServletRequest request, HttpServletResponse response) {
        SLOProfile slo = (SLOProfile)((Object)this.profiles.get("urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout"));
        if (slo == null) {
            return null;
        }
        String logoutURL = slo.getEndpoint().getLocation();
        SAMLCredential credential = this.getSamlCredential(request);
        BasicSAMLMessageContext context = new BasicSAMLMessageContext();
        this.populateLocalContext((SAMLMessageContext)context);
        try {
            LogoutRequest logoutRequest = slo.buildLogoutRequest((SAMLMessageContext)context, credential);
            logoutRequest.setDestination(slo.getEndpoint().getLocation());
            context.setOutboundSAMLMessage((SAMLObject)logoutRequest);
            HTTPRedirectBinding binding = (HTTPRedirectBinding)this.getBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            logoutURL = binding.buildRedirectURL((SAMLMessageContext)context, slo.getEndpoint().getLocation());
        }
        catch (SAMLException e) {
            log.error((Object)"Failed to get SAML Logout request", (Throwable)e);
        }
        return logoutURL;
    }

    private SAMLCredential getSamlCredential(HttpServletRequest request) {
        SAMLCredential credential = null;
        Cookie cookie = this.getCookie(request, SAML_SESSION_KEY);
        if (cookie != null) {
            String[] parts = cookie.getValue().split("\\|");
            String sessionId = parts[0];
            String nameValue = parts[1];
            String nameFormat = parts[2];
            NameID nameID = (NameID)Configuration.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME).buildObject(NameID.DEFAULT_ELEMENT_NAME);
            nameID.setValue(nameValue);
            nameID.setFormat(nameFormat);
            ArrayList<String> sessionIndexes = new ArrayList<String>();
            sessionIndexes.add(sessionId);
            credential = new SAMLCredential(nameID, sessionIndexes);
        }
        return credential;
    }

    public Boolean handleLogout(HttpServletRequest request, HttpServletResponse response) {
        String logoutURL = this.getSLOUrl(request, response);
        if (logoutURL == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send redirect to " + logoutURL));
        }
        try {
            response.sendRedirect(logoutURL);
        }
        catch (IOException e) {
            String errorMessage = String.format("Unable to send redirect on %s", logoutURL);
            log.error((Object)errorMessage, (Throwable)e);
            return false;
        }
        Cookie cookie = this.getCookie(request, SAML_SESSION_KEY);
        if (cookie != null) {
            this.removeCookie(response, cookie);
        }
        return true;
    }

    private void sendError(HttpServletRequest req, String key) {
        String msg = I18NUtils.getMessageString((String)"messages", (String)key, null, (Locale)req.getLocale());
        req.setAttribute("org.nuxeo.ecm.login.error", (Object)msg);
    }

    private KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = (KeyManager)Framework.getLocalService(KeyManager.class);
        }
        return this.keyManager;
    }

    private void addCookie(HttpServletResponse httpResponse, String name, String value) {
        Cookie cookie = new Cookie(name, value);
        httpResponse.addCookie(cookie);
    }

    private Cookie getCookie(HttpServletRequest httpRequest, String cookieName) {
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cooky : cookies) {
                if (!cookieName.equals(cooky.getName())) continue;
                return cooky;
            }
        }
        return null;
    }

    private void removeCookie(HttpServletResponse httpResponse, Cookie cookie) {
        log.debug((Object)String.format("Removing cookie %s.", cookie.getName()));
        cookie.setMaxAge(0);
        cookie.setValue("");
        httpResponse.addCookie(cookie);
    }

    static {
        bindings.add(new HTTPPostBinding());
        bindings.add(new HTTPRedirectBinding());
        encryptedKeyResolver = new ChainingEncryptedKeyResolver();
        encryptedKeyResolver.getResolverChain().add(new InlineEncryptedKeyResolver());
        encryptedKeyResolver.getResolverChain().add(new EncryptedElementTypeEncryptedKeyResolver());
        encryptedKeyResolver.getResolverChain().add(new SimpleRetrievalMethodEncryptedKeyResolver());
    }
}

