/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.jboss.seam.deployment.AbstractDeploymentHandler;
import org.jboss.seam.deployment.DeploymentMetadata;
import org.jboss.seam.deployment.FileDescriptor;

public class ComponentsXmlDeploymentHandler
extends AbstractDeploymentHandler {
    private Pattern INF_PATTERN = Pattern.compile("(WEB-INF/components.xml$)|(META-INF/components.xml$)");
    private static DeploymentMetadata COMPONENTSXML_SUFFIX_FILE_METADATA = new DeploymentMetadata(){

        @Override
        public String getFileNameSuffix() {
            return "components.xml";
        }
    };
    public static final String NAME = "org.jboss.seam.deployment.ComponentsXmlDeploymentHandler";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DeploymentMetadata getMetadata() {
        return COMPONENTSXML_SUFFIX_FILE_METADATA;
    }

    @Override
    public void postProcess(ClassLoader classLoader) {
        HashSet<FileDescriptor> resources = new HashSet<FileDescriptor>();
        for (FileDescriptor fileDescriptor : this.getResources()) {
            String path = fileDescriptor.getName();
            if (this.INF_PATTERN.matcher(path).matches()) continue;
            resources.add(fileDescriptor);
        }
        this.setResources(resources);
    }
}

