/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ServerSideStateHelper;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Conversation;

public class NuxeoServerSideStateHelper
extends ServerSideStateHelper {
    private static final Log log = LogFactory.getLog(NuxeoServerSideStateHelper.class);
    public static final int DEFAULT_NUMBER_OF_CONVERSATIONS_IN_SESSION = 4;
    public static final String NUMBER_OF_CONVERSATIONS_IN_SESSION = "nuxeo.jsf.numberOfConversationsInSession";
    protected static final String NO_LONGRUNNING_CONVERSATION_ID = "NOLRC";
    protected static Integer numbersOfConversationsInSession = null;
    public static final String CONVERSATION_VIEW_MAP = NuxeoServerSideStateHelper.class.getName() + ".ConversationViewMap";

    protected static int getNbOfConversationsInSession(FacesContext context) {
        if (numbersOfConversationsInSession == null) {
            ExternalContext externalContext = context.getExternalContext();
            String value = externalContext.getInitParameter(NUMBER_OF_CONVERSATIONS_IN_SESSION);
            if (null == value) {
                numbersOfConversationsInSession = 4;
            } else {
                try {
                    numbersOfConversationsInSession = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new FacesException("Context parameter nuxeo.jsf.numberOfConversationsInSession must have integer value");
                }
            }
        }
        return numbersOfConversationsInSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState(FacesContext ctx, Object state, StringBuilder stateCapture) throws IOException {
        String id;
        Util.notNull((String)"context", (Object)ctx);
        if (!ctx.getViewRoot().isTransient()) {
            Util.notNull((String)"state", (Object)state);
            Object[] stateToWrite = (Object[])state;
            ExternalContext externalContext = ctx.getExternalContext();
            Object sessionObj = externalContext.getSession(true);
            Map sessionMap = externalContext.getSessionMap();
            Object object = sessionObj;
            synchronized (object) {
                Map actualMap;
                Map logicalMap;
                Map conversationMap;
                String conversationId = NO_LONGRUNNING_CONVERSATION_ID;
                if (Contexts.isConversationContextActive() && Conversation.instance().isLongRunning()) {
                    conversationId = Conversation.instance().getId();
                }
                if ((conversationMap = TypedCollections.dynamicallyCastMap((Map)((Map)sessionMap.get(CONVERSATION_VIEW_MAP)), String.class, Map.class)) == null) {
                    conversationMap = new LRUMap(NuxeoServerSideStateHelper.getNbOfConversationsInSession(ctx));
                    sessionMap.put(CONVERSATION_VIEW_MAP, conversationMap);
                }
                if ((logicalMap = TypedCollections.dynamicallyCastMap((Map)((Map)conversationMap.get(conversationId)), String.class, Map.class)) == null) {
                    if (conversationMap.size() == NuxeoServerSideStateHelper.getNbOfConversationsInSession(ctx) && log.isDebugEnabled()) {
                        log.warn((Object)("Too many conversations, dumping the least recently used conversation (" + (String)conversationMap.keySet().iterator().next() + ")"));
                    }
                    logicalMap = new LRUMap(this.numberOfLogicalViews.intValue());
                    conversationMap.put(conversationId, logicalMap);
                }
                Object structure = stateToWrite[0];
                Object savedState = this.handleSaveState(stateToWrite[1]);
                String idInLogicalMap = (String)RequestStateManager.get((FacesContext)ctx, (String)"com.sun.faces.logicalViewMap");
                if (idInLogicalMap == null) {
                    idInLogicalMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
                }
                String idInActualMap = null;
                if (ctx.getPartialViewContext().isPartialRequest()) {
                    idInActualMap = (String)RequestStateManager.get((FacesContext)ctx, (String)"com.sun.faces.actualViewMap");
                }
                if (null == idInActualMap) {
                    String string = idInActualMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
                }
                if ((actualMap = TypedCollections.dynamicallyCastMap((Map)((Map)logicalMap.get(idInLogicalMap)), String.class, Object[].class)) == null) {
                    actualMap = new LRUMap(this.numberOfViews.intValue());
                    logicalMap.put(idInLogicalMap, actualMap);
                }
                id = idInLogicalMap + ':' + idInActualMap;
                Object[] stateArray = (Object[])actualMap.get(idInActualMap);
                if (stateArray != null) {
                    stateArray[0] = structure;
                    stateArray[1] = savedState;
                } else {
                    actualMap.put(idInActualMap, new Object[]{structure, savedState});
                }
                conversationMap.put(conversationId, logicalMap);
                sessionMap.put(CONVERSATION_VIEW_MAP, conversationMap);
            }
        } else {
            id = "stateless";
        }
        if (stateCapture != null) {
            stateCapture.append(id);
        } else {
            ResponseWriter writer = ctx.getResponseWriter();
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)"javax.faces.ViewState", null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering)) {
                String viewStateId = Util.getViewStateId((FacesContext)ctx);
                writer.writeAttribute("id", (Object)viewStateId, null);
            }
            writer.writeAttribute("value", (Object)id, null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                writer.writeAttribute("autocomplete", (Object)"off", null);
            }
            writer.endElement("input");
            this.writeClientWindowField(ctx, writer);
            this.writeRenderKitIdField(ctx, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getState(FacesContext ctx, String viewId) {
        String compoundId = NuxeoServerSideStateHelper.getStateParamValue((FacesContext)ctx);
        if (compoundId == null) {
            return null;
        }
        if ("stateless".equals(compoundId)) {
            return "stateless";
        }
        int sep = compoundId.indexOf(58);
        assert (sep != -1);
        assert (sep < compoundId.length());
        String idInLogicalMap = compoundId.substring(0, sep);
        String idInActualMap = compoundId.substring(sep + 1);
        ExternalContext externalCtx = ctx.getExternalContext();
        Object sessionObj = externalCtx.getSession(false);
        if (sessionObj == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Unable to restore server side state for view ID %s as no session is available", viewId));
            }
            return null;
        }
        Object object = sessionObj;
        synchronized (object) {
            Map actualMap;
            Map conversationMap = (Map)externalCtx.getSessionMap().get(CONVERSATION_VIEW_MAP);
            if (conversationMap == null) {
                return null;
            }
            Map logicalMap = null;
            for (Map lm : conversationMap.values()) {
                if (lm.get(idInLogicalMap) == null) continue;
                logicalMap = lm;
                break;
            }
            if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                RequestStateManager.set((FacesContext)ctx, (String)"com.sun.faces.logicalViewMap", (Object)idInLogicalMap);
                Object[] state = (Object[])actualMap.get(idInActualMap);
                Object[] restoredState = new Object[2];
                if (state != null) {
                    restoredState[0] = state[0];
                    restoredState[1] = state[1];
                    RequestStateManager.set((FacesContext)ctx, (String)"com.sun.faces.actualViewMap", (Object)idInActualMap);
                    if (state.length == 2 && state[1] != null) {
                        restoredState[1] = this.handleRestoreState(state[1]);
                    }
                }
                return restoredState;
            }
        }
        return null;
    }

    private String createIncrementalRequestId(FacesContext ctx) {
        Map sm = ctx.getExternalContext().getSessionMap();
        AtomicInteger idgen = (AtomicInteger)sm.get(STATEMANAGED_SERIAL_ID_KEY);
        if (idgen == null) {
            idgen = new AtomicInteger(1);
        }
        sm.put(STATEMANAGED_SERIAL_ID_KEY, idgen);
        return "j_id" + idgen.getAndIncrement();
    }

    private String createRandomId() {
        return Long.valueOf(this.random.nextLong()).toString();
    }
}

