/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasEvent;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;

public class UIAliasHolder
extends UIOutput {
    private static final Log log = LogFactory.getLog(UIAliasHolder.class);
    public static final String COMPONENT_TYPE = UIAliasHolder.class.getName();
    public static final String COMPONENT_FAMILY = UIAliasHolder.class.getName();
    protected transient AliasVariableMapper alias;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getRendererType() {
        return null;
    }

    public void setRendererType(String rendererType) {
    }

    public boolean isRendered() {
        return true;
    }

    public void setRendered(boolean rendered) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) {
        if (event instanceof AliasEvent) {
            FacesContext context = this.getFacesContext();
            AliasVariableMapper alias = this.getAliasVariableMapper();
            try {
                AliasVariableMapper.exposeAliasesToRequest(context, alias);
                FacesEvent origEvent = ((AliasEvent)event).getOriginalEvent();
                origEvent.getComponent().broadcast(origEvent);
            }
            finally {
                if (alias != null) {
                    AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        event = new AliasEvent((UIComponent)this, event);
        super.queueEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        AliasVariableMapper alias = this.getAliasVariableMapper();
        try {
            AliasVariableMapper.exposeAliasesToRequest(context, alias);
            boolean bl = super.invokeOnComponent(context, clientId, callback);
            return bl;
        }
        finally {
            if (alias != null) {
                AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        AliasVariableMapper alias = this.getAliasVariableMapper();
        AliasVariableMapper.exposeAliasesToRequest(context, alias);
        super.encodeBegin(context);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        this.processFacetsAndChildren(context, PhaseId.RENDER_RESPONSE);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        AliasVariableMapper alias = this.getAliasVariableMapper();
        if (alias != null) {
            AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
        }
    }

    public void processDecodes(FacesContext context) {
        this.processFacetsAndChildrenWithVariables(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    public void processValidators(FacesContext context) {
        this.processFacetsAndChildrenWithVariables(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processUpdates(FacesContext context) {
        this.processFacetsAndChildrenWithVariables(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    protected final void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        List stamps = this.getChildren();
        for (UIComponent stamp : stamps) {
            this.processComponent(context, stamp, phaseId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processFacetsAndChildrenWithVariables(FacesContext context, PhaseId phaseId) {
        AliasVariableMapper alias = this.getAliasVariableMapper();
        try {
            AliasVariableMapper.exposeAliasesToRequest(context, alias);
            this.processFacetsAndChildren(context, phaseId);
        }
        finally {
            if (alias != null) {
                AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
            }
        }
    }

    protected final void processComponent(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (component != null) {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                component.processDecodes(context);
            } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                component.processValidators(context);
            } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                component.processUpdates(context);
            } else if (phaseId == PhaseId.RENDER_RESPONSE) {
                try {
                    ComponentSupport.encodeRecursive((FacesContext)context, (UIComponent)component);
                }
                catch (IOException err) {
                    log.error((Object)("Error while rendering component " + component));
                }
            } else {
                throw new IllegalArgumentException("Bad PhaseId:" + phaseId);
            }
        }
    }

    public AliasVariableMapper getAlias() {
        return this.alias;
    }

    public void setAlias(AliasVariableMapper alias) {
        this.alias = alias;
    }

    protected AliasVariableMapper getAliasVariableMapper() {
        return this.getAlias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        if (!this.isVisitable(visitContext)) {
            return false;
        }
        FacesContext facesContext = visitContext.getFacesContext();
        AliasVariableMapper alias = this.getAliasVariableMapper();
        try {
            AliasVariableMapper.exposeAliasesToRequest(facesContext, alias);
            boolean bl = super.visitTree(visitContext, callback);
            return bl;
        }
        finally {
            if (alias != null) {
                AliasVariableMapper.removeAliasesExposedToRequest(facesContext, alias.getId());
            }
        }
    }
}

