/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.component.list.EditableListModificationType;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.model.EditableModel;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

public class EditableListBean {
    private static final Log log = LogFactory.getLog(EditableListBean.class);
    public static final String FOR_PARAMETER_NAME = "for";
    public static final String INDEX_PARAMETER_NAME = "index";
    public static final String TYPE_PARAMETER_NAME = "type";
    public static final String NUMBER_PARAMETER_NAME = "number";
    protected UIComponent binding;

    public UIComponent getBinding() {
        return this.binding;
    }

    public void setBinding(UIComponent binding) {
        this.binding = binding;
    }

    public void performAction(String listComponentId, String index, String type) {
        if (this.binding == null) {
            log.error((Object)"Component binding not set, cannot perform action");
            return;
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put(FOR_PARAMETER_NAME, listComponentId);
        requestMap.put(INDEX_PARAMETER_NAME, index);
        requestMap.put(TYPE_PARAMETER_NAME, type);
        EditableListBean.performAction(this.binding, requestMap);
    }

    public void performAction(ActionEvent event) {
        this.performAction((FacesEvent)event);
    }

    public void performAction(AjaxBehaviorEvent event) {
        this.performAction((FacesEvent)event);
    }

    protected void performAction(FacesEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        Map requestMap = eContext.getRequestParameterMap();
        EditableListBean.performAction(component, requestMap);
    }

    @Deprecated
    public void resetAllListsCachedModels(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent anchor = ComponentUtils.getBase(component);
        this.resetListCachedModels(anchor);
    }

    @Deprecated
    protected void resetListCachedModels(UIComponent parent) {
        List children;
        if (parent == null) {
            return;
        }
        if (parent instanceof UIEditableList) {
            ((UIEditableList)parent).resetCachedModel();
        }
        if ((children = parent.getChildren()) != null && !children.isEmpty()) {
            for (UIComponent child : children) {
                this.resetListCachedModels(child);
            }
        }
    }

    protected static void performAction(UIComponent binding, Map<String, String> requestMap) {
        UIEditableList editableComp = EditableListBean.getEditableListComponent(binding, requestMap);
        if (editableComp == null) {
            return;
        }
        EditableListModificationType type = EditableListBean.getModificationType(requestMap);
        if (type == null) {
            return;
        }
        EditableModel model = editableComp.getEditableModel();
        Object template = editableComp.getTemplate();
        switch (type) {
            case ADD: {
                Integer number = EditableListBean.getNumber(requestMap);
                if (number == null) {
                    model.addValue(template);
                    break;
                }
                for (int i = 0; i < number; ++i) {
                    model.addTemplateValue();
                }
                break;
            }
            case INSERT: {
                Integer index = EditableListBean.getIndex(requestMap);
                if (index == null) {
                    return;
                }
                Integer number = EditableListBean.getNumber(requestMap);
                if (number == null) {
                    model.insertValue(index, template);
                    break;
                }
                for (int i = 0; i < number; ++i) {
                    model.insertTemplateValue(index);
                }
                break;
            }
            case REMOVE: {
                Integer index = EditableListBean.getIndex(requestMap);
                if (index == null) {
                    return;
                }
                editableComp.removeValue(index);
                break;
            }
            case MOVEUP: {
                Integer index = EditableListBean.getIndex(requestMap);
                if (index == null) {
                    return;
                }
                editableComp.moveValue(index, index - 1);
                break;
            }
            case MOVEDOWN: {
                Integer index = EditableListBean.getIndex(requestMap);
                if (index == null) {
                    return;
                }
                editableComp.moveValue(index, index + 1);
            }
        }
    }

    protected static String getParameterValue(Map<String, String> requestMap, String parameterName) {
        String string = requestMap.get(parameterName);
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    protected static UIEditableList getEditableListComponent(UIComponent component, Map<String, String> requestMap) {
        UIEditableList listComponent = null;
        String forString = EditableListBean.getParameterValue(requestMap, FOR_PARAMETER_NAME);
        if (forString == null) {
            log.error((Object)"Could not find 'for' parameter in the request map");
        } else {
            UIComponent forComponent = component.findComponent(forString);
            if (forComponent == null) {
                log.error((Object)("Could not find component with id: " + forString));
            } else if (!(forComponent instanceof UIEditableList)) {
                log.error((Object)("Invalid component with id " + forString + ": " + forComponent + ", expected a component with class " + UIEditableList.class));
            } else {
                listComponent = (UIEditableList)forComponent;
            }
        }
        return listComponent;
    }

    protected static EditableListModificationType getModificationType(Map<String, String> requestMap) {
        EditableListModificationType type = null;
        String typeString = EditableListBean.getParameterValue(requestMap, TYPE_PARAMETER_NAME);
        if (typeString == null) {
            log.error((Object)"Could not find 'type' parameter in the request map");
        } else {
            try {
                type = EditableListModificationType.valueOfString(typeString);
            }
            catch (IllegalArgumentException err) {
                log.error((Object)("Illegal value for 'type' attribute: " + typeString + ", should be one of " + Arrays.toString((Object[])EditableListModificationType.values())));
            }
        }
        return type;
    }

    protected static Integer getIndex(Map<String, String> requestMap) {
        Integer index = null;
        String indexString = EditableListBean.getParameterValue(requestMap, INDEX_PARAMETER_NAME);
        if (indexString == null) {
            log.error((Object)"Could not find 'index' parameter in the request map");
        } else {
            try {
                index = Integer.valueOf(indexString);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Illegal value for 'index' attribute: " + indexString + ", should be integer"));
            }
        }
        return index;
    }

    protected static Integer getNumber(Map<String, String> requestMap) {
        Integer number = null;
        String numberString = EditableListBean.getParameterValue(requestMap, NUMBER_PARAMETER_NAME);
        if (numberString != null) {
            try {
                number = Integer.valueOf(numberString);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Illegal value for 'number' attribute: " + numberString + ", should be integer"));
            }
        }
        return number;
    }

    public List<Object> getDummyList() {
        ArrayList<Object> dummy = new ArrayList<Object>(1);
        dummy.add("dummy");
        return dummy;
    }
}

