/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.threed.ThreeDInfo;
import org.nuxeo.ecm.platform.threed.ThreeDRenderView;
import org.nuxeo.ecm.platform.threed.TransmissionThreeD;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.runtime.api.Framework;

public class BatchConverterHelper {
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String DEPTH = "depth";
    public static final String FORMAT = "format";
    private static final Log log = LogFactory.getLog(BatchConverterHelper.class);

    private BatchConverterHelper() {
    }

    protected static final BlobHolder convertTexture(BlobHolder resource, Integer percentage, String maxSize) {
        ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
        float percScale = 1.0f;
        if (percentage != null) {
            percScale = (float)((double)percentage.intValue() / 100.0);
        }
        float maxScale = 1.0f;
        Map infoTexture = resource.getProperties();
        if (maxSize != null) {
            String[] size = maxSize.split("x");
            int width = Integer.parseInt(size[0]);
            int height = Integer.parseInt(size[1]);
            maxScale = Math.min((float)width / (float)((Integer)((Serializable)infoTexture.get(WIDTH))).intValue(), (float)height / (float)((Integer)((Serializable)infoTexture.get(HEIGHT))).intValue());
        }
        if ((double)percScale >= 1.0 && (double)maxScale >= 1.0) {
            return resource;
        }
        float scale = Math.min(maxScale, percScale);
        HashMap<String, Integer> lodInfoTexture = new HashMap<String, Integer>();
        lodInfoTexture.put(WIDTH, Math.round((float)((Integer)((Serializable)infoTexture.get(WIDTH))).intValue() * scale));
        lodInfoTexture.put(HEIGHT, Math.round((float)((Integer)((Serializable)infoTexture.get(HEIGHT))).intValue() * scale));
        lodInfoTexture.put(DEPTH, (Integer)infoTexture.get(DEPTH));
        lodInfoTexture.put(FORMAT, (Integer)infoTexture.get(FORMAT));
        Blob lodBlob = imagingService.resize(resource.getBlob(), (String)lodInfoTexture.get(FORMAT), ((Integer)((Serializable)lodInfoTexture.get(WIDTH))).intValue(), ((Integer)((Serializable)lodInfoTexture.get(HEIGHT))).intValue(), ((Integer)((Serializable)lodInfoTexture.get(DEPTH))).intValue());
        lodBlob.setFilename(resource.getBlob().getFilename());
        return new SimpleBlobHolderWithProperties(lodBlob, lodInfoTexture);
    }

    public static final List<TransmissionThreeD> getTransmissions(BlobHolder batch, List<BlobHolder> resources) {
        ThreeDService threeDService = (ThreeDService)Framework.getService(ThreeDService.class);
        List blobs = batch.getBlobs();
        Map lodIdIndexes = (Map)((Object)batch.getProperty("lodIdIndexes"));
        return threeDService.getAutomaticLODs().stream().map(automaticLOD -> {
            Integer index = (Integer)lodIdIndexes.get(automaticLOD.getId());
            if (index != null) {
                Blob dae = (Blob)blobs.get(index);
                List<BlobHolder> lodResources = resources.stream().map(resource -> BatchConverterHelper.convertTexture(resource, automaticLOD.getPercTex(), automaticLOD.getMaxTex())).collect(Collectors.toList());
                List lodResourceBlobs = lodResources.stream().map(BlobHolder::getBlob).collect(Collectors.toList());
                Integer idx = (Integer)((Map)((Object)batch.getProperty("infoIndexes"))).get(automaticLOD.getId());
                if (idx == null) {
                    return null;
                }
                Blob infoBlob = (Blob)batch.getBlobs().get(idx);
                ThreeDInfo info = null;
                try {
                    info = BatchConverterHelper.getInfo(infoBlob, lodResources);
                }
                catch (IOException e) {
                    log.warn((Object)e);
                    info = null;
                }
                return new TransmissionThreeD(dae, lodResourceBlobs, info, automaticLOD.getPercPoly(), automaticLOD.getMaxPoly(), automaticLOD.getPercTex(), automaticLOD.getMaxTex(), automaticLOD.getName());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static final ThreeDInfo getMainInfo(BlobHolder batch, List<BlobHolder> resources) {
        ThreeDInfo info;
        Integer idx = (Integer)((Map)((Object)batch.getProperty("infoIndexes"))).get("default");
        if (idx == null) {
            return null;
        }
        Blob infoBlob = (Blob)batch.getBlobs().get(idx);
        try {
            info = BatchConverterHelper.getInfo(infoBlob, resources);
        }
        catch (IOException e) {
            log.warn((Object)e);
            info = null;
        }
        return info;
    }

    protected static final ThreeDInfo getInfo(Blob blob, List<BlobHolder> resources) throws IOException {
        Map<String, Serializable> infoMap = BatchConverterHelper.convertToInfo(blob);
        int maxWidth = resources.stream().mapToInt(resource -> (Integer)resource.getProperty(WIDTH)).max().orElse(0);
        int maxHeight = resources.stream().mapToInt(resource -> (Integer)resource.getProperty(HEIGHT)).max().orElse(0);
        long resourcesSize = resources.stream().mapToLong(resource -> resource.getBlob().getFile().length()).sum();
        infoMap.put("texture_lod_success", Boolean.TRUE);
        infoMap.put("textures_max_dimension", (Serializable)((Object)(String.valueOf(maxWidth) + "x" + String.valueOf(maxHeight))));
        infoMap.put("textures_size", Long.valueOf(resourcesSize));
        return new ThreeDInfo(infoMap);
    }

    protected static final Map<String, Serializable> convertToInfo(Blob blob) throws IOException {
        HashMap<String, Serializable> geomInfo = new HashMap<String, Serializable>();
        ObjectMapper mapper = new ObjectMapper();
        Map info = (Map)mapper.readValue(blob.getFile(), Map.class);
        if (info.get("global") != null && info.get("global") instanceof Map) {
            Map infoGlobal = (Map)info.get("global");
            geomInfo.put("geometry_lod_success", (Serializable)infoGlobal.get("geometry_lod_success"));
            geomInfo.put("non_manifold_polygons", Long.valueOf(((Integer)infoGlobal.get("non_manifold_polygons")).longValue()));
            geomInfo.put("non_manifold_edges", Long.valueOf(((Integer)infoGlobal.get("non_manifold_edges")).longValue()));
            geomInfo.put("non_manifold_vertices", Long.valueOf(((Integer)infoGlobal.get("non_manifold_vertices")).longValue()));
            geomInfo.put("polygons", Long.valueOf(((Integer)infoGlobal.get("polygons")).longValue()));
            geomInfo.put("edges", Long.valueOf(((Integer)infoGlobal.get("edges")).longValue()));
            geomInfo.put("vertices", Long.valueOf(((Integer)infoGlobal.get("vertices")).longValue()));
            geomInfo.put("position_x", (Serializable)infoGlobal.get("position_x"));
            geomInfo.put("position_y", (Serializable)infoGlobal.get("position_y"));
            geomInfo.put("position_z", (Serializable)infoGlobal.get("position_z"));
            geomInfo.put("dimension_x", (Serializable)infoGlobal.get("dimension_x"));
            geomInfo.put("dimension_y", (Serializable)infoGlobal.get("dimension_y"));
            geomInfo.put("dimension_z", (Serializable)infoGlobal.get("dimension_z"));
        }
        return geomInfo;
    }

    public static final List<BlobHolder> getResources(BlobHolder batch) {
        List blobs = batch.getBlobs();
        return ((List)((Object)batch.getProperty("resourceIndexes"))).stream().map(blobs::get).map(resource -> {
            HashMap<String, Object> infoTexture = new HashMap<String, Object>();
            ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
            ImageInfo imageInfo = imagingService.getImageInfo(resource);
            if (imageInfo == null) {
                return null;
            }
            infoTexture.put(WIDTH, imageInfo.getWidth());
            infoTexture.put(HEIGHT, imageInfo.getHeight());
            infoTexture.put(FORMAT, imageInfo.getFormat());
            infoTexture.put(DEPTH, imageInfo.getDepth());
            return new SimpleBlobHolderWithProperties(resource, infoTexture);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static final Blob createThumbnail(Blob render) {
        ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
        ImageInfo imageInfo = imagingService.getImageInfo(render);
        float scale = Math.min(350.0f / (float)imageInfo.getWidth(), 350.0f / (float)imageInfo.getHeight());
        return imagingService.resize(render, imageInfo.getFormat(), Math.round((float)imageInfo.getWidth() * scale), Math.round((float)imageInfo.getHeight() * scale), imageInfo.getDepth());
    }

    public static final List<ThreeDRenderView> getRenders(BlobHolder batch) {
        List allBlobs = batch.getBlobs();
        List blobs = allBlobs.subList((Integer)batch.getProperty("renderStartIndex"), allBlobs.size());
        ThreeDService threeDService = (ThreeDService)Framework.getService(ThreeDService.class);
        ArrayList orderedRV = new ArrayList(threeDService.getAutomaticRenderViews());
        ArrayList remainingRV = new ArrayList(threeDService.getAvailableRenderViews());
        remainingRV.removeAll(orderedRV);
        orderedRV.addAll(remainingRV);
        return orderedRV.stream().map(renderView -> {
            Blob png = blobs.stream().filter(blob -> {
                String[] fileNameArray = FilenameUtils.getBaseName((String)blob.getFilename()).split("-");
                return renderView.getId().equals(fileNameArray[1]);
            }).findFirst().orElse(null);
            if (png == null) {
                return null;
            }
            return new ThreeDRenderView(renderView.getName(), png, BatchConverterHelper.createThumbnail(png), renderView.getAzimuth().intValue(), renderView.getZenith().intValue());
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

