/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.adapter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.threed.ThreeD;
import org.nuxeo.ecm.platform.threed.ThreeDDocument;
import org.nuxeo.ecm.platform.threed.ThreeDInfo;
import org.nuxeo.ecm.platform.threed.ThreeDRenderView;
import org.nuxeo.ecm.platform.threed.TransmissionThreeD;

public class ThreeDDocumentAdapter
implements ThreeDDocument {
    final DocumentModel docModel;

    public ThreeDDocumentAdapter(DocumentModel threed) {
        this.docModel = threed;
    }

    public ThreeD getThreeD() {
        BlobHolder bh = (BlobHolder)this.docModel.getAdapter(BlobHolder.class);
        List resources = ((List)((Object)this.docModel.getPropertyValue("files:files"))).stream().map(file -> (Blob)file.get("file")).collect(Collectors.toList());
        Map infoMap = (Map)((Object)this.docModel.getPropertyValue("threed:info"));
        ThreeDInfo info = infoMap != null ? new ThreeDInfo(infoMap) : null;
        return new ThreeD(bh.getBlob(), resources, info);
    }

    public Collection<TransmissionThreeD> getTransmissionThreeDs() {
        List list = (List)((Object)this.docModel.getPropertyValue("threed:transmissionFormats"));
        return list.stream().map(TransmissionThreeD::new).collect(Collectors.toList());
    }

    public TransmissionThreeD getTransmissionThreeD(String name) {
        List list = (List)((Object)this.docModel.getPropertyValue("threed:transmissionFormats"));
        return list.stream().filter(item -> (String)item.get("name") != null && name.equals(item.get("name"))).map(TransmissionThreeD::new).findFirst().orElse(null);
    }

    public Collection<ThreeDRenderView> getRenderViews() {
        List list = (List)((Object)this.docModel.getPropertyValue("threed:renderViews"));
        return list.stream().map(ThreeDRenderView::new).collect(Collectors.toList());
    }

    public ThreeDRenderView getRenderView(String title) {
        List list = (List)((Object)this.docModel.getPropertyValue("threed:renderViews"));
        return list.stream().filter(item -> title.equals(item.get("title"))).map(ThreeDRenderView::new).findFirst().orElse(null);
    }
}

