/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.delegate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Lifecycle;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.runtime.api.Framework;

@Name(value="documentManager")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentManagerBusinessDelegate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentManagerBusinessDelegate.class);
    protected final Map<RepositoryLocation, CloseableCoreSession> sessions = new HashMap<RepositoryLocation, CloseableCoreSession>();

    public void initialize() {
        log.debug((Object)"Seam component initialized...");
    }

    @Unwrap
    public CoreSession getDocumentManager() {
        RepositoryLocation currentServerLocation = (RepositoryLocation)Component.getInstance((String)"currentServerLocation");
        return this.getDocumentManager(currentServerLocation);
    }

    public CoreSession getDocumentManager(RepositoryLocation serverLocation) {
        if (serverLocation == null) {
            return null;
        }
        CloseableCoreSession session = this.sessions.get(serverLocation);
        if (session == null) {
            if (Lifecycle.isDestroying()) {
                return null;
            }
            String serverName = serverLocation.getName();
            session = CoreInstance.openCoreSession((String)serverName);
            log.debug((Object)("Opened session for repository " + serverName));
            this.sessions.put(serverLocation, session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Destroy
    @PermitAll
    public void remove() {
        LoginContext lc = null;
        try {
            try {
                if (Framework.getRuntime() != null) {
                    lc = Framework.login();
                }
            }
            catch (LoginException le) {
                log.error((Object)"Unable to login as System", (Throwable)le);
                log.warn((Object)"...try to feed CoreSession(s) without system login ...");
            }
            for (Map.Entry<RepositoryLocation, CloseableCoreSession> entry : this.sessions.entrySet()) {
                String serverName = entry.getKey().getName();
                CloseableCoreSession session = entry.getValue();
                session.close();
                log.debug((Object)("Closed session for repository " + serverName));
            }
        }
        finally {
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException lo) {
                    log.error((Object)"Error when logout", (Throwable)lo);
                }
            }
            this.sessions.clear();
        }
    }
}

