/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.userworkspace;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;

public class MultiTenantUserWorkspaceService
extends DefaultUserWorkspaceServiceImpl {
    private static final long serialVersionUID = 1L;

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, DocumentModel currentDocument) throws ClientException {
        String tenantId = MultiTenantHelper.getCurrentTenantId(userCoreSession.getPrincipal());
        if (StringUtils.isBlank((String)tenantId)) {
            return super.computePathUserWorkspaceRoot(userCoreSession, currentDocument);
        }
        return this.computePathUserWorkspaceRoot(userCoreSession, tenantId);
    }

    protected String computePathUserWorkspaceRoot(CoreSession session, String tenantId) throws ClientException {
        String tenantDocumentPath = MultiTenantHelper.getTenantDocumentPath(session, tenantId);
        Path path = new Path(tenantDocumentPath);
        path = path.append("UserWorkspaces");
        return path.toString();
    }

    protected String computePathForUserWorkspace(CoreSession userCoreSession, String userName, DocumentModel currentDocument) throws ClientException {
        if (this.isSameUserName(userCoreSession, userName)) {
            return super.computePathForUserWorkspace(userCoreSession, userName, currentDocument);
        }
        String tenantId = MultiTenantHelper.getTenantId(userName);
        if (StringUtils.isBlank((String)tenantId)) {
            return super.computePathForUserWorkspace(userCoreSession, userName, currentDocument);
        }
        return this.computePathForUserWorkspace(userCoreSession, tenantId, userName);
    }

    protected String computePathForUserWorkspace(CoreSession session, String tenantId, String userName) throws ClientException {
        String rootPath = this.computePathUserWorkspaceRoot(session, tenantId);
        Path path = new Path(rootPath);
        path = path.append(MultiTenantUserWorkspaceService.getUserWorkspaceNameForUser((String)userName));
        return path.toString();
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(String userName, CoreSession userCoreSession, DocumentModel context) throws ClientException {
        if (this.isSameUserName(userCoreSession, userName)) {
            return super.getCurrentUserPersonalWorkspace(userName, userCoreSession, context);
        }
        String tenantId = MultiTenantHelper.getTenantId(userName);
        if (StringUtils.isBlank((String)tenantId)) {
            return super.getCurrentUserPersonalWorkspace(userName, userCoreSession, context);
        }
        PathRef uwsDocRef = new PathRef(this.computePathForUserWorkspace(userCoreSession, tenantId, userName));
        if (!userCoreSession.exists((DocumentRef)uwsDocRef)) {
            PathRef rootRef = new PathRef(this.computePathUserWorkspaceRoot(userCoreSession, tenantId));
            uwsDocRef = this.createUserWorkspace(rootRef, uwsDocRef, userCoreSession, userName);
        }
        if (userCoreSession.getClass().getSimpleName().equals("LocalSession")) {
            userCoreSession.save();
        }
        return userCoreSession.getDocument((DocumentRef)uwsDocRef);
    }

    protected boolean isSameUserName(CoreSession session, String userName) {
        return session.getPrincipal().getName().equals(userName);
    }
}

