/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        String tenantDocumentType = multiTenantService.getTenantDocumentType();
        if (tenantDocumentType == null) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        if ("documentCreated".equals(event.getName()) || "documentCreatedByCopy".equals(event.getName())) {
            DocumentModel doc = docCtx.getSourceDocument();
            CoreSession session = docCtx.getCoreSession();
            if (tenantDocumentType.equals(doc.getType()) && multiTenantService.isTenantIsolationEnabled(session)) {
                multiTenantService.enableTenantIsolationFor(session, doc);
                session.save();
            }
        } else if ("documentRemoved".equals(event.getName())) {
            DocumentModel doc = docCtx.getSourceDocument();
            CoreSession session = docCtx.getCoreSession();
            if (tenantDocumentType.equals(doc.getType()) && multiTenantService.isTenantIsolationEnabled(session)) {
                multiTenantService.disableTenantIsolationFor(session, doc);
                session.save();
            }
        }
    }
}

