/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.multi.tenant.MultiTenantConfiguration;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.multi.tenant.MultiTenantPrincipal;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class MultiTenantServiceImpl
extends DefaultComponent
implements MultiTenantService {
    private static final Log log = LogFactory.getLog(MultiTenantServiceImpl.class);
    public static final String CONFIGURATION_EP = "configuration";
    private MultiTenantConfiguration configuration;
    private Boolean isTenantIsolationEnabled;

    @Override
    public boolean isTenantIsolationEnabledByDefault() {
        return this.configuration.isEnabledByDefault();
    }

    @Override
    public String getTenantDocumentType() {
        return this.configuration.getTenantDocumentType();
    }

    @Override
    public boolean isTenantIsolationEnabled(CoreSession session) throws ClientException {
        if (this.isTenantIsolationEnabled == null) {
            final ArrayList tenants = new ArrayList();
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    String query = "SELECT * FROM Document WHERE ecm:mixinType = 'TenantConfig'";
                    tenants.addAll(this.session.query(query));
                }
            }.runUnrestricted();
            this.isTenantIsolationEnabled = !tenants.isEmpty();
        }
        return this.isTenantIsolationEnabled;
    }

    @Override
    public void enableTenantIsolation(CoreSession session) throws ClientException {
        if (!this.isTenantIsolationEnabled(session)) {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    String query = "SELECT * FROM Document WHERE ecm:primaryType = '%s'";
                    DocumentModelList docs = this.session.query(String.format(query, MultiTenantServiceImpl.this.configuration.getTenantDocumentType()));
                    for (DocumentModel doc : docs) {
                        MultiTenantServiceImpl.this.enableTenantIsolationFor(this.session, doc);
                    }
                    this.session.save();
                }
            }.runUnrestricted();
            this.isTenantIsolationEnabled = true;
        }
    }

    @Override
    public void disableTenantIsolation(CoreSession session) throws ClientException {
        if (this.isTenantIsolationEnabled(session)) {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    String query = "SELECT * FROM Document WHERE ecm:mixinType = 'TenantConfig'";
                    DocumentModelList docs = this.session.query(query);
                    for (DocumentModel doc : docs) {
                        MultiTenantServiceImpl.this.disableTenantIsolationFor(this.session, doc);
                    }
                    this.session.save();
                }
            }.runUnrestricted();
            this.isTenantIsolationEnabled = false;
        }
    }

    @Override
    public void enableTenantIsolationFor(CoreSession session, DocumentModel doc) throws ClientException {
        if (!doc.hasFacet("TenantConfig")) {
            doc.addFacet("TenantConfig");
        }
        DocumentModel d = this.registerTenant(doc);
        String tenantId = (String)((Object)d.getPropertyValue("tenant:id"));
        doc.setPropertyValue("tenantconfig:tenantId", (Serializable)((Object)tenantId));
        this.setTenantACL(tenantId, doc);
        session.saveDocument(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentModel registerTenant(DocumentModel doc) throws ClientException {
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try (Session session = null;){
            session = directoryService.open("tenants");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", doc.getName());
            m.put("label", doc.getTitle());
            m.put("docId", doc.getId());
            DocumentModel documentModel = session.createEntry(m);
            return documentModel;
        }
    }

    private void setTenantACL(String tenantId, DocumentModel doc) throws ClientException {
        ACP acp = doc.getACP();
        ACL acl = acp.getOrCreateACL();
        String tenantAdministratorsGroup = MultiTenantHelper.computeTenantAdministratorsGroup(tenantId);
        acl.add((Object)new ACE(tenantAdministratorsGroup, "Everything", true));
        String tenantMembersGroup = MultiTenantHelper.computeTenantMembersGroup(tenantId);
        String membersGroupPermission = this.configuration.getMembersGroupPermission();
        if (!StringUtils.isBlank((String)membersGroupPermission)) {
            acl.add((Object)new ACE(tenantMembersGroup, membersGroupPermission, true));
        }
        acl.add((Object)new ACE("Everyone", "Everything", false));
        doc.setACP(acp, true);
    }

    @Override
    public void disableTenantIsolationFor(CoreSession session, DocumentModel doc) throws ClientException {
        if (session.exists(doc.getRef())) {
            if (doc.hasFacet("TenantConfig")) {
                doc.removeFacet("TenantConfig");
            }
            this.removeTenantACL(doc);
            session.saveDocument(doc);
        }
        this.unregisterTenant(doc);
    }

    private void removeTenantACL(DocumentModel doc) throws ClientException {
        String tenantId;
        String tenantAdministratorsGroup;
        ACP acp = doc.getACP();
        ACL acl = acp.getOrCreateACL();
        int tenantAdministratorsGroupACEIndex = acl.indexOf((Object)new ACE(tenantAdministratorsGroup = MultiTenantHelper.computeTenantAdministratorsGroup(tenantId = doc.getName()), "Everything", true));
        if (tenantAdministratorsGroupACEIndex >= 0) {
            ArrayList newACEs = new ArrayList();
            newACEs.addAll(acl.subList(0, tenantAdministratorsGroupACEIndex));
            newACEs.addAll(acl.subList(tenantAdministratorsGroupACEIndex + 3, acl.size()));
            acl.setACEs(newACEs.toArray(new ACE[newACEs.size()]));
        }
        doc.setACP(acp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterTenant(DocumentModel doc) throws ClientException {
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try (Session session = null;){
            session = directoryService.open("tenants");
            session.deleteEntry(doc.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DocumentModel> getTenants() throws ClientException {
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try (Session session = null;){
            session = directoryService.open("tenants");
            DocumentModelList documentModelList = session.getEntries();
            return documentModelList;
        }
    }

    @Override
    public boolean isTenantAdministrator(Principal principal) {
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal p = (MultiTenantPrincipal)((Object)principal);
            return p.getTenantId() != null && p.isMemberOf("powerusers");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(ComponentContext context) {
        boolean started = false;
        boolean ok = false;
        try {
            started = TransactionHelper.startTransaction();
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            for (String repositoryName : repositoryManager.getRepositoryNames()) {
                new UnrestrictedSessionRunner(repositoryName){

                    public void run() throws ClientException {
                        if (MultiTenantServiceImpl.this.isTenantIsolationEnabledByDefault() && !MultiTenantServiceImpl.this.isTenantIsolationEnabled(this.session)) {
                            MultiTenantServiceImpl.this.enableTenantIsolation(this.session);
                        }
                    }
                }.runUnrestricted();
            }
            ok = true;
        }
        finally {
            if (started) {
                try {
                    if (!ok) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                }
                finally {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            if (this.configuration != null) {
                log.warn((Object)"Overriding existing multi tenant configuration");
            }
            this.configuration = (MultiTenantConfiguration)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint) && this.configuration.equals(contribution)) {
            this.configuration = null;
        }
    }

    @Override
    public List<String> getProhibitedGroups() {
        if (this.configuration != null) {
            return this.configuration.getProhibitedGroups();
        }
        return null;
    }
}

