/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.operations;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Services.QueryUsers", category="Services", label="Query users", description="Query users filtered by a tenantId if provided.")
public class QueryUsers {
    public static final String ID = "Services.QueryUsers";
    public static final Set<String> FULLTEXT_FIELDS = new HashSet<String>(Arrays.asList("username", "firstName", "lastName"));
    @Context
    protected UserManager userManager;
    @Param(name="pattern", required=false)
    protected String pattern;
    @Param(name="tenantId", required=false)
    protected String tenantId;

    @OperationMethod
    public Blob run() throws Exception {
        ArrayList<DocumentModel> users = new ArrayList<DocumentModel>();
        if (StringUtils.isBlank((String)this.pattern)) {
            HashMap<String, String> filter = new HashMap<String, String>();
            if (!StringUtils.isBlank((String)this.tenantId)) {
                filter.put("tenantId", this.tenantId);
            }
            users.addAll((Collection<DocumentModel>)this.userManager.searchUsers(filter, filter.keySet()));
        } else {
            for (String field : FULLTEXT_FIELDS) {
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put(field, this.pattern);
                if (!StringUtils.isBlank((String)this.tenantId)) {
                    filter.put("tenantId", this.tenantId);
                }
                users.addAll((Collection<DocumentModel>)this.userManager.searchUsers(filter, filter.keySet()));
            }
        }
        return this.buildResponse(users);
    }

    protected Blob buildResponse(List<DocumentModel> users) throws UnsupportedEncodingException, ClientException {
        JSONArray array = new JSONArray();
        for (DocumentModel user : users) {
            JSONObject o = new JSONObject();
            o.element("username", user.getProperty("user", "username"));
            o.element("firstName", user.getProperty("user", "firstName"));
            o.element("lastName", user.getProperty("user", "lastName"));
            o.element("email", user.getProperty("user", "email"));
            o.element("company", user.getProperty("user", "company"));
            o.element("tenantId", user.getProperty("user", "tenantId"));
            array.add((Object)o);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"users", (Object)array);
        return Blobs.createBlob((String)result.toString(), (String)"application/json");
    }
}

