/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import java.io.Serializable;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.directory.DirectoryUIActionsBean;
import org.nuxeo.runtime.api.Framework;

@Name(value="multiTenantActions")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class MultiTenantActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TENANT_ADMINISTRATORS_VALIDATION_ERROR = "label.tenant.administrators.validation.error";
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected DirectoryUIActionsBean directoryUIActions;

    public List<DocumentModel> getTenants() {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        return multiTenantService.getTenants();
    }

    public boolean isTenantIsolationEnabled() {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        return multiTenantService.isTenantIsolationEnabled(this.documentManager);
    }

    public void enableTenantIsolation() {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        multiTenantService.enableTenantIsolation(this.documentManager);
    }

    public void disableTenantIsolation() {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        multiTenantService.disableTenantIsolation(this.documentManager);
    }

    public boolean isReadOnlyDirectory(String directoryName) {
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getLocalService(MultiTenantService.class);
        if (multiTenantService.isTenantIsolationEnabled(this.documentManager) && multiTenantService.isTenantAdministrator(this.documentManager.getPrincipal())) {
            DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            return !directoryService.getDirectory(directoryName).isMultiTenant();
        }
        return this.directoryUIActions.isReadOnly(directoryName);
    }

    public void validateTenantAdministrators(FacesContext context, UIComponent component, Object value) {
        List users;
        String administratorGroup;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String currentDocumentTenantId = (String)((Object)currentDocument.getPropertyValue("tenantconfig:tenantId"));
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.documentManager.getPrincipal();
        String currentUserTenantId = currentUser.getTenantId();
        if (!StringUtils.isBlank((String)currentDocumentTenantId) && !StringUtils.isBlank((String)currentUserTenantId) && currentUserTenantId.equals(currentDocumentTenantId) && currentUser.isMemberOf(administratorGroup = MultiTenantHelper.computeTenantAdministratorsGroup(currentDocumentTenantId)) && !(users = (List)value).contains(currentUser.getName())) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)TENANT_ADMINISTRATORS_VALIDATION_ERROR), null);
            throw new ValidatorException(message);
        }
    }
}

